/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.io.InputStream;
import java.util.Optional;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encoding;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encodings;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;

enum BinaryEncoding implements Encoding
{
    INSTANCE;

    static final String CONTENT_TYPE = "application/octet-stream";
    static final TypeMarker<InputStream> MARKER;
    static final TypeMarker<Optional<InputStream>> OPTIONAL_MARKER;

    @Override
    public <T> Encoding.Serializer<T> serializer(TypeMarker<T> _type) {
        throw new UnsupportedOperationException("BinaryEncoding does not support serializers");
    }

    @Override
    public <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
        if (MARKER.equals(type)) {
            return InputStreamDeserializer.INSTANCE;
        }
        if (OPTIONAL_MARKER.equals(type)) {
            return OptionalInputStreamDeserializer.INSTANCE;
        }
        throw new SafeIllegalStateException("BinaryEncoding only supports InputStream and Optional<InputStream>", SafeArg.of("requested", type));
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public boolean supportsContentType(String contentType) {
        return Encodings.matchesContentType(CONTENT_TYPE, contentType);
    }

    public String toString() {
        return "BinaryEncoding{application/octet-stream}";
    }

    static {
        MARKER = new TypeMarker<InputStream>(){};
        OPTIONAL_MARKER = new TypeMarker<Optional<InputStream>>(){};
    }

    static enum InputStreamDeserializer implements Encoding.Deserializer<InputStream>
    {
        INSTANCE;


        @Override
        public InputStream deserialize(InputStream input) {
            return input;
        }

        public String toString() {
            return "InputStreamDeserializer{}";
        }
    }

    static enum OptionalInputStreamDeserializer implements Encoding.Deserializer<Optional<InputStream>>
    {
        INSTANCE;


        @Override
        public Optional<InputStream> deserialize(InputStream input) {
            return Optional.of(input);
        }

        public String toString() {
            return "OptionalInputStreamDeserializer{}";
        }
    }
}

