/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Caffeine;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.CaffeineSpec;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.LoadingCache;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.Lists;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.BinaryEncoding;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.EmptyContainerDeserializer;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encoding;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.ErrorDecoder;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.LazilyInitializedEncoding;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.TracedEncoding;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.WeightedEncoding;
import shadow.palantir.driver.com.palantir.dialogue.BinaryRequestBody;
import shadow.palantir.driver.com.palantir.dialogue.BodySerDe;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.RequestBody;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.Serializer;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;

final class ConjureBodySerDe
implements BodySerDe {
    private static final SafeLogger log = SafeLoggerFactory.get(ConjureBodySerDe.class);
    private final List<Encoding> encodingsSortedByWeight;
    private final Encoding defaultEncoding;
    private final Deserializer<InputStream> binaryInputStreamDeserializer;
    private final Deserializer<Optional<InputStream>> optionalBinaryInputStreamDeserializer;
    private final Deserializer<Void> emptyBodyDeserializer;
    private final LoadingCache<Type, Serializer<?>> serializers;
    private final LoadingCache<Type, Deserializer<?>> deserializers;

    ConjureBodySerDe(List<WeightedEncoding> rawEncodings, ErrorDecoder errorDecoder, EmptyContainerDeserializer emptyContainerDeserializer, CaffeineSpec cacheSpec) {
        List<WeightedEncoding> encodings = ConjureBodySerDe.decorateEncodings(rawEncodings);
        this.encodingsSortedByWeight = this.sortByWeight(encodings);
        Preconditions.checkArgument(encodings.size() > 0, "At least one Encoding is required");
        this.defaultEncoding = encodings.get(0).encoding();
        this.binaryInputStreamDeserializer = new EncodingDeserializerRegistry<InputStream>(ImmutableList.of(BinaryEncoding.INSTANCE), errorDecoder, emptyContainerDeserializer, BinaryEncoding.MARKER);
        this.optionalBinaryInputStreamDeserializer = new EncodingDeserializerRegistry<Optional<InputStream>>(ImmutableList.of(BinaryEncoding.INSTANCE), errorDecoder, emptyContainerDeserializer, BinaryEncoding.OPTIONAL_MARKER);
        this.emptyBodyDeserializer = new EmptyBodyDeserializer(errorDecoder);
        this.serializers = Caffeine.from(cacheSpec).build(type -> new EncodingSerializerRegistry(this.defaultEncoding, TypeMarker.of(type)));
        this.deserializers = Caffeine.from(cacheSpec).build(type -> new EncodingDeserializerRegistry(this.encodingsSortedByWeight, errorDecoder, emptyContainerDeserializer, TypeMarker.of(type)));
    }

    private static List<WeightedEncoding> decorateEncodings(List<WeightedEncoding> input) {
        return input.stream().map(weightedEncoding -> WeightedEncoding.of(new LazilyInitializedEncoding(new TracedEncoding(weightedEncoding.encoding())), weightedEncoding.weight())).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<Encoding> sortByWeight(List<WeightedEncoding> encodings) {
        ArrayList<WeightedEncoding> mutableEncodings = new ArrayList<WeightedEncoding>(encodings);
        mutableEncodings.sort(Comparator.comparing(WeightedEncoding::weight).reversed());
        return ImmutableList.copyOf(Lists.transform(mutableEncodings, WeightedEncoding::encoding));
    }

    @Override
    public <T> Serializer<T> serializer(TypeMarker<T> token) {
        return this.serializers.get(token.getType());
    }

    @Override
    public <T> Deserializer<T> deserializer(TypeMarker<T> token) {
        return this.deserializers.get(token.getType());
    }

    @Override
    public Deserializer<Void> emptyBodyDeserializer() {
        return this.emptyBodyDeserializer;
    }

    @Override
    public Deserializer<InputStream> inputStreamDeserializer() {
        return this.binaryInputStreamDeserializer;
    }

    @Override
    public Deserializer<Optional<InputStream>> optionalInputStreamDeserializer() {
        return this.optionalBinaryInputStreamDeserializer;
    }

    @Override
    public RequestBody serialize(final BinaryRequestBody value) {
        Preconditions.checkNotNull(value, "A BinaryRequestBody value is required");
        return new RequestBody(){

            @Override
            public void writeTo(OutputStream output) throws IOException {
                value.write(output);
            }

            @Override
            public String contentType() {
                return "application/octet-stream";
            }

            @Override
            public boolean repeatable() {
                return value.repeatable();
            }

            @Override
            public void close() {
                try {
                    value.close();
                }
                catch (IOException | RuntimeException e) {
                    log.warn("Failed to close BinaryRequestBody {}", UnsafeArg.of("body", value), (Throwable)e);
                }
            }
        };
    }

    private static final class EmptyBodyDeserializer
    implements Deserializer<Void> {
        private final ErrorDecoder errorDecoder;

        EmptyBodyDeserializer(ErrorDecoder errorDecoder) {
            this.errorDecoder = errorDecoder;
        }

        @Override
        public Void deserialize(Response response) {
            try (Response unused = response;){
                if (this.errorDecoder.isError(response)) {
                    throw this.errorDecoder.decode(response);
                }
                Void void_ = null;
                return void_;
            }
        }

        @Override
        public Optional<String> accepts() {
            return Optional.empty();
        }

        public String toString() {
            return "EmptyBodyDeserializer{}";
        }
    }

    private static final class EncodingDeserializerContainer<T> {
        private final Encoding encoding;
        private final Encoding.Deserializer<T> deserializer;

        EncodingDeserializerContainer(Encoding encoding, TypeMarker<T> token) {
            this.encoding = encoding;
            this.deserializer = encoding.deserializer(token);
        }

        public String toString() {
            return "EncodingDeserializerContainer{encoding=" + this.encoding + ", deserializer=" + this.deserializer + "}";
        }
    }

    private static final class EncodingDeserializerRegistry<T>
    implements Deserializer<T> {
        private static final SafeLogger log = SafeLoggerFactory.get(EncodingDeserializerRegistry.class);
        private final ImmutableList<EncodingDeserializerContainer<T>> encodings;
        private final ErrorDecoder errorDecoder;
        private final Optional<String> acceptValue;
        private final Supplier<Optional<T>> emptyInstance;
        private final TypeMarker<T> token;

        EncodingDeserializerRegistry(List<Encoding> encodings, ErrorDecoder errorDecoder, EmptyContainerDeserializer empty, TypeMarker<T> token) {
            this.encodings = encodings.stream().map(encoding -> new EncodingDeserializerContainer((Encoding)encoding, token)).collect(ImmutableList.toImmutableList());
            this.errorDecoder = errorDecoder;
            this.token = token;
            this.emptyInstance = Suppliers.memoize(() -> empty.tryGetEmptyInstance(token));
            this.acceptValue = Optional.of(encodings.stream().map(Encoding::getContentType).collect(Collectors.joining(", ")));
        }

        @Override
        public T deserialize(Response response) {
            boolean closeResponse = true;
            try {
                if (this.errorDecoder.isError(response)) {
                    throw this.errorDecoder.decode(response);
                }
                if (response.code() == 204) {
                    Optional<T> maybeEmptyInstance = this.emptyInstance.get();
                    if (maybeEmptyInstance.isPresent()) {
                        T t = maybeEmptyInstance.get();
                        return t;
                    }
                    throw new SafeRuntimeException("Unable to deserialize non-optional response type from 204", SafeArg.of("type", this.token));
                }
                Optional<String> contentType = response.getFirstHeader("Content-Type");
                if (!contentType.isPresent()) {
                    throw new SafeIllegalArgumentException("Response is missing Content-Type header", SafeArg.of("received", response.headers().keySet()));
                }
                Encoding.Deserializer<T> deserializer = this.getResponseDeserializer(contentType.get());
                T deserialized = deserializer.deserialize(response.body());
                closeResponse = false;
                T t = deserialized;
                return t;
            }
            catch (IOException e) {
                throw new SafeRuntimeException("Failed to deserialize response stream", (Throwable)e, SafeArg.of("contentType", response.getFirstHeader("Content-Type")), SafeArg.of("type", this.token));
            }
            finally {
                if (closeResponse) {
                    response.close();
                }
            }
        }

        @Override
        public Optional<String> accepts() {
            return this.acceptValue;
        }

        Encoding.Deserializer<T> getResponseDeserializer(String contentType) {
            for (int i = 0; i < this.encodings.size(); ++i) {
                EncodingDeserializerContainer container = (EncodingDeserializerContainer)this.encodings.get(i);
                if (!container.encoding.supportsContentType(contentType)) continue;
                return container.deserializer;
            }
            return this.throwingDeserializer(contentType);
        }

        private Encoding.Deserializer<T> throwingDeserializer(final String contentType) {
            return new Encoding.Deserializer<T>(){

                @Override
                public T deserialize(InputStream input) {
                    try {
                        input.close();
                    }
                    catch (IOException | RuntimeException e) {
                        log.warn("Failed to close InputStream", e);
                    }
                    throw new SafeRuntimeException("Unsupported Content-Type", SafeArg.of("received", contentType), SafeArg.of("supportedEncodings", encodings));
                }
            };
        }
    }

    private static final class EncodingSerializerContainer<T> {
        private final Encoding encoding;
        private final Encoding.Serializer<T> serializer;

        EncodingSerializerContainer(Encoding encoding, TypeMarker<T> token) {
            this.encoding = encoding;
            this.serializer = encoding.serializer(token);
        }
    }

    private static final class EncodingSerializerRegistry<T>
    implements Serializer<T> {
        private final EncodingSerializerContainer<T> encoding;

        EncodingSerializerRegistry(Encoding encoding, TypeMarker<T> token) {
            this.encoding = new EncodingSerializerContainer<T>(encoding, token);
        }

        @Override
        public RequestBody serialize(final T value) {
            Preconditions.checkNotNull(value, "cannot serialize null value");
            return new RequestBody(){

                @Override
                public void writeTo(OutputStream output) throws IOException {
                    encoding.serializer.serialize(value, output);
                }

                @Override
                public String contentType() {
                    return encoding.encoding.getContentType();
                }

                @Override
                public boolean repeatable() {
                    return true;
                }

                @Override
                public void close() {
                }
            };
        }
    }
}

