/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.RemoteException;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.UnknownRemoteException;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Clients;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.DialogueException;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.RequestBody;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.blocking.CallingThreadExecutor;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;

enum DefaultClients implements Clients
{
    INSTANCE;

    private static final SafeLogger log;

    @Override
    public <T> ListenableFuture<T> call(Channel channel, Endpoint endpoint, Request request, Deserializer<T> deserializer) {
        return this.call(new EndpointChannelAdapter(endpoint, channel), request, deserializer);
    }

    @Override
    public <T> ListenableFuture<T> call(EndpointChannel channel, Request request, Deserializer<T> deserializer) {
        Optional<String> accepts = deserializer.accepts();
        Request outgoingRequest = accepts.isPresent() ? DefaultClients.accepting(request, accepts.get()) : request;
        ListenableFuture<Response> response = DefaultClients.closeRequestBodyOnCompletion(channel.execute(outgoingRequest), outgoingRequest);
        return DialogueFutures.transform(response, deserializer::deserialize);
    }

    @Override
    public <T> T callBlocking(EndpointChannel channel, Request request, Deserializer<T> deserializer) {
        CallingThreadExecutor callingThreadExecutor = CallingThreadExecutor.useCallingThreadExecutor(request);
        ListenableFuture<T> call = this.call(channel, request, deserializer);
        callingThreadExecutor.executeQueue(call);
        return this.block(call);
    }

    @Override
    public EndpointChannel bind(Channel channel, Endpoint endpoint) {
        if (channel instanceof EndpointChannelFactory) {
            return ((EndpointChannelFactory)((Object)channel)).endpoint(endpoint);
        }
        if (log.isDebugEnabled()) {
            log.debug("Channel of type {} does not implement EndpointChannelFactory, which is recommended for maximum performance. Falling back to lambda impl.", SafeArg.of("type", channel.getClass().getSimpleName()), SafeArg.of("serviceName", endpoint.serviceName()), SafeArg.of("endpointName", endpoint.endpointName()), UnsafeArg.of("channel", channel), new SafeRuntimeException("Exception for stacktrace", new Arg[0]));
        }
        return new EndpointChannelAdapter(endpoint, channel);
    }

    private static ListenableFuture<Response> closeRequestBodyOnCompletion(ListenableFuture<Response> responseFuture, Request request) {
        Optional<RequestBody> requestBody = request.body();
        if (requestBody.isPresent()) {
            DialogueFutures.addDirectListener(responseFuture, requestBody.get()::close);
        }
        return responseFuture;
    }

    @Override
    public <T> T block(ListenableFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!future.cancel(true)) {
                Futures.addCallback(future, CancelListener.INSTANCE, DialogueFutures.safeDirectExecutor());
            }
            throw new DialogueException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException) {
                throw DefaultClients.newRemoteException((RemoteException)cause);
            }
            if (cause instanceof UnknownRemoteException) {
                throw DefaultClients.newUnknownRemoteException((UnknownRemoteException)cause);
            }
            if (cause instanceof RuntimeException) {
                cause.addSuppressed(new SafeRuntimeException("Rethrown by dialogue", new Arg[0]));
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                cause.addSuppressed(new SafeRuntimeException("Rethrown by dialogue", new Arg[0]));
                throw (Error)cause;
            }
            throw new DialogueException(cause);
        }
    }

    private static RemoteException newRemoteException(RemoteException remoteException) {
        RemoteException newException = new RemoteException(remoteException.getError(), remoteException.getStatus());
        newException.initCause(remoteException);
        return newException;
    }

    private static UnknownRemoteException newUnknownRemoteException(UnknownRemoteException cause) {
        UnknownRemoteException newException = new UnknownRemoteException(cause.getStatus(), cause.getBody());
        newException.initCause(cause);
        return newException;
    }

    private static Request accepting(Request original, String acceptValue) {
        Preconditions.checkNotNull(acceptValue, "Accept value is required");
        Preconditions.checkState(!acceptValue.isEmpty(), "Accept value must not be empty");
        if (original.headerParams().containsKey("Accept")) {
            log.warn("Request {} already contains an Accept header value {}", UnsafeArg.of("request", original), SafeArg.of("existingAcceptValue", original.headerParams().get((Object)"Accept")));
            return original;
        }
        return Request.builder().from(original).putHeaderParams("Accept", acceptValue).build();
    }

    static {
        log = SafeLoggerFactory.get(DefaultClients.class);
    }

    private static final class EndpointChannelAdapter
    implements EndpointChannel {
        private final Endpoint endpoint;
        private final Channel channel;

        EndpointChannelAdapter(Endpoint endpoint, Channel channel) {
            this.endpoint = Preconditions.checkNotNull(endpoint, "Endpoint must not be null");
            this.channel = Preconditions.checkNotNull(channel, "Channel must not be null");
        }

        @Override
        public ListenableFuture<Response> execute(Request request) {
            return this.channel.execute(this.endpoint, request);
        }

        public String toString() {
            return "EndpointChannelAdapter{endpoint=" + this.endpoint + ", channel=" + this.channel + "}";
        }
    }

    static enum CancelListener implements FutureCallback<Object>
    {
        INSTANCE;


        @Override
        public void onSuccess(Object result) {
            Optional resultOptional;
            if (result instanceof Closeable) {
                try {
                    ((Closeable)result).close();
                }
                catch (IOException | RuntimeException e) {
                    log.info("Failed to close result of {} after the call was canceled", UnsafeArg.of("result", result), (Throwable)e);
                }
            } else if (result instanceof Optional && (resultOptional = (Optional)result).isPresent()) {
                this.onSuccess(resultOptional.get());
            }
        }

        @Override
        public void onFailure(Throwable throwable) {
            log.info("Canceled call failed", throwable);
        }
    }
}

