/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.CaffeineSpec;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.ConjureBodySerDe;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.ConjurePlainSerDe;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.DefaultClients;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encoding;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encodings;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.ErrorDecoder;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.WeightedEncoding;
import shadow.palantir.driver.com.palantir.dialogue.BodySerDe;
import shadow.palantir.driver.com.palantir.dialogue.Clients;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.PlainSerDe;

public final class DefaultConjureRuntime
implements ConjureRuntime {
    @VisibleForTesting
    static final CaffeineSpec DEFAULT_SERDE_CACHE_SPEC = CaffeineSpec.parse("maximumSize=1000,expireAfterAccess=1m,weakKeys,weakValues");
    static final ImmutableList<WeightedEncoding> DEFAULT_ENCODINGS = ImmutableList.of(WeightedEncoding.of(Encodings.json(), 0.9), WeightedEncoding.of(Encodings.smile(), 1.0), WeightedEncoding.of(Encodings.cbor(), 0.7));
    private final BodySerDe bodySerDe;

    private DefaultConjureRuntime(Builder builder) {
        this.bodySerDe = new ConjureBodySerDe(builder.encodings.isEmpty() ? DEFAULT_ENCODINGS : builder.encodings, ErrorDecoder.INSTANCE, Encodings.emptyContainerDeserializer(), DEFAULT_SERDE_CACHE_SPEC);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public BodySerDe bodySerDe() {
        return this.bodySerDe;
    }

    @Override
    public PlainSerDe plainSerDe() {
        return ConjurePlainSerDe.INSTANCE;
    }

    @Override
    public Clients clients() {
        return DefaultClients.INSTANCE;
    }

    public static final class Builder {
        private final List<WeightedEncoding> encodings = new ArrayList<WeightedEncoding>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder encodings(Encoding value) {
            this.encodings.add(WeightedEncoding.of(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder encodings(Encoding value, double weight) {
            this.encodings.add(WeightedEncoding.of(value, weight));
            return this;
        }

        public DefaultConjureRuntime build() {
            return new DefaultConjureRuntime(this);
        }
    }
}

