/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import com.palantir.logsafe.Preconditions;
import java.io.InputStream;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectReader;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectWriter;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.EmptyContainerDeserializer;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encoding;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.JacksonEmptyContainerLoader;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.ObjectMappers;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class Encodings {
    private static final Supplier<ObjectMapper> JSON_MAPPER = Suppliers.memoize(() -> Encodings.configure(ObjectMappers.newClientObjectMapper()));

    private Encodings() {
    }

    public static Encoding json() {
        return new AbstractJacksonEncoding(JSON_MAPPER.get()){
            private static final String CONTENT_TYPE = "application/json";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }

            @Override
            public boolean supportsContentType(String contentType) {
                return Encodings.matchesContentType(CONTENT_TYPE, contentType);
            }
        };
    }

    public static Encoding cbor() {
        return new AbstractJacksonEncoding(Encodings.configure(ObjectMappers.newCborClientObjectMapper())){
            private static final String CONTENT_TYPE = "application/cbor";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }

            @Override
            public boolean supportsContentType(String contentType) {
                return Encodings.matchesContentType(CONTENT_TYPE, contentType);
            }
        };
    }

    public static Encoding smile() {
        return new AbstractJacksonEncoding(Encodings.configure(ObjectMappers.newSmileClientObjectMapper())){
            private static final String CONTENT_TYPE = "application/x-jackson-smile";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }

            @Override
            public boolean supportsContentType(String contentType) {
                return Encodings.matchesContentType(CONTENT_TYPE, contentType);
            }
        };
    }

    static EmptyContainerDeserializer emptyContainerDeserializer() {
        return new JacksonEmptyContainerLoader(JSON_MAPPER.get());
    }

    static boolean matchesContentType(String contentType, @Nullable String typeToCheck) {
        return typeToCheck != null && typeToCheck.startsWith(contentType);
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        return mapper.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET).disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    }

    private static abstract class AbstractJacksonEncoding
    implements Encoding {
        private final ObjectMapper mapper;

        AbstractJacksonEncoding(ObjectMapper mapper) {
            this.mapper = Preconditions.checkNotNull(mapper, "ObjectMapper is required");
        }

        @Override
        public final <T> Encoding.Serializer<T> serializer(TypeMarker<T> type) {
            ObjectWriter writer = this.mapper.writerFor(this.mapper.constructType(type.getType()));
            return (value, output) -> writer.writeValue(output, Preconditions.checkNotNull(value, "cannot serialize null value"));
        }

        @Override
        public final <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
            ObjectReader reader = this.mapper.readerFor(this.mapper.constructType(type.getType()));
            return input -> {
                try (InputStream inputStream = input;){
                    Object value = reader.readValue(inputStream);
                    Object t = Preconditions.checkNotNull(value, "cannot deserialize a JSON null value");
                    return t;
                }
            };
        }

        public final String toString() {
            return "AbstractJacksonEncoding{" + this.getContentType() + "}";
        }
    }
}

