/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeExceptions;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableCollection;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.io.CharStreams;
import shadow.palantir.driver.com.google.common.primitives.Longs;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.QosException;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.QosReason;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.RemoteException;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.SerializableError;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.UnknownRemoteException;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encodings;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.ObjectMappers;
import shadow.palantir.driver.com.palantir.dialogue.Response;

public enum ErrorDecoder {
    INSTANCE;

    private static final SafeLogger log;
    private static final ObjectMapper MAPPER;
    @VisibleForTesting
    static final QosReason QOS_REASON;

    public boolean isError(Response response) {
        return 300 <= response.code() && response.code() <= 599;
    }

    public RuntimeException decode(Response response) {
        if (log.isDebugEnabled()) {
            log.debug("Received an error response", ErrorDecoder.diagnosticArgs(response));
        }
        RuntimeException result = this.decodeInternal(response);
        result.addSuppressed(ErrorDecoder.diagnostic(response));
        return result;
    }

    private RuntimeException decodeInternal(Response response) {
        String body;
        int code = response.code();
        switch (code) {
            case 308: {
                Optional<String> location = response.getFirstHeader("Location");
                if (location.isPresent()) {
                    String locationHeader = location.get();
                    try {
                        UnknownRemoteException remoteException = new UnknownRemoteException(code, "");
                        remoteException.initCause(QosException.retryOther(QOS_REASON, new URL(locationHeader)));
                        return remoteException;
                    }
                    catch (MalformedURLException e) {
                        log.error("Failed to parse location header for QosException.RetryOther", UnsafeArg.of("locationHeader", locationHeader), (Throwable)e);
                        break;
                    }
                }
                log.error("Retrieved HTTP status code 308 without Location header, cannot perform redirect. This appears to be a server-side protocol violation.");
                break;
            }
            case 429: {
                return response.getFirstHeader("Retry-After").map(Longs::tryParse).map(Duration::ofSeconds).map(duration -> QosException.throttle(QOS_REASON, duration)).orElseGet(() -> QosException.throttle(QOS_REASON));
            }
            case 503: {
                return QosException.unavailable(QOS_REASON);
            }
        }
        try {
            body = ErrorDecoder.toString(response.body());
        }
        catch (IOException | NullPointerException e) {
            UnknownRemoteException exception = new UnknownRemoteException(code, "<unparseable>");
            exception.initCause(e);
            return exception;
        }
        Optional<String> contentType = response.getFirstHeader("Content-Type");
        if (contentType.isPresent() && Encodings.matchesContentType("application/json", contentType.get())) {
            try {
                SerializableError serializableError = MAPPER.readValue(body, SerializableError.class);
                return new RemoteException(serializableError, code);
            }
            catch (Exception e) {
                return new UnknownRemoteException(code, body);
            }
        }
        return new UnknownRemoteException(code, body);
    }

    private static String toString(InputStream body) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(body, StandardCharsets.UTF_8);){
            String string = CharStreams.toString(reader);
            return string;
        }
    }

    private static ResponseDiagnostic diagnostic(Response response) {
        return new ResponseDiagnostic(ErrorDecoder.diagnosticArgs(response));
    }

    private static ImmutableList<Arg<?>> diagnosticArgs(Response response) {
        ImmutableCollection.Builder args = ImmutableList.builder().add(SafeArg.of("status", response.code()));
        ErrorDecoder.recordHeader("Server", response, args);
        ErrorDecoder.recordHeader("Content-Type", response, args);
        ErrorDecoder.recordHeader("Content-Length", response, args);
        ErrorDecoder.recordHeader("Connection", response, args);
        ErrorDecoder.recordHeader("Date", response, args);
        ErrorDecoder.recordHeader("x-envoy-response-flags", response, args);
        ErrorDecoder.recordHeader("x-envoy-response-code-details", response, args);
        ErrorDecoder.recordHeader("Response-Flags", response, args);
        ErrorDecoder.recordHeader("Response-Code-Details", response, args);
        return ((ImmutableList.Builder)args).build();
    }

    private static void recordHeader(String header, Response response, ImmutableList.Builder<Arg<?>> args) {
        response.getFirstHeader(header).ifPresent(server -> args.add(SafeArg.of(header, server)));
    }

    static {
        log = SafeLoggerFactory.get(ErrorDecoder.class);
        MAPPER = ObjectMappers.newClientObjectMapper();
        QOS_REASON = QosReason.of("client-qos-response");
    }

    private static final class ResponseDiagnostic
    extends RuntimeException
    implements SafeLoggable {
        private static final String SAFE_MESSAGE = "Response Diagnostic Information";
        private final ImmutableList<Arg<?>> args;

        ResponseDiagnostic(ImmutableList<Arg<?>> args) {
            super(SafeExceptions.renderMessage(SAFE_MESSAGE, args.toArray(new Arg[0])));
            this.args = args;
        }

        @Override
        public String getLogMessage() {
            return SAFE_MESSAGE;
        }

        @Override
        public List<Arg<?>> getArgs() {
            return this.args;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

