/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.EmptyContainerDeserializer;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.javax.annotation.Nullable;

final class JacksonEmptyContainerLoader
implements EmptyContainerDeserializer {
    private static final SafeLogger log = SafeLoggerFactory.get(JacksonEmptyContainerLoader.class);
    private final ObjectMapper mapper;

    JacksonEmptyContainerLoader(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> Optional<T> tryGetEmptyInstance(TypeMarker<T> token) {
        return this.constructEmptyInstance(token.getType(), token, 10);
    }

    private Optional<Object> constructEmptyInstance(Type type, TypeMarker<?> originalType, int maxRecursion) {
        Optional<Object> collection = JacksonEmptyContainerLoader.coerceCollections(type);
        if (collection.isPresent()) {
            return collection;
        }
        Optional<Object> jacksonInstance = this.jacksonDeserializeFromNull(type);
        if (jacksonInstance.isPresent()) {
            return jacksonInstance;
        }
        Method method = JacksonEmptyContainerLoader.getJsonCreatorStaticMethod(type);
        if (method != null) {
            Type parameterType = method.getParameters()[0].getParameterizedType();
            Optional<Object> parameter = this.constructEmptyInstance(parameterType, originalType, JacksonEmptyContainerLoader.decrement(maxRecursion, originalType));
            if (parameter.isPresent()) {
                return JacksonEmptyContainerLoader.invokeStaticFactoryMethod(method, parameter.get());
            }
            if (log.isDebugEnabled()) {
                log.debug("Found a @JsonCreator, but couldn't construct the parameter", SafeArg.of("type", type), SafeArg.of("parameter", parameter));
            }
            return Optional.empty();
        }
        if (log.isDebugEnabled()) {
            log.debug("Jackson couldn't instantiate an empty instance and also couldn't find a usable @JsonCreator", SafeArg.of("type", type));
        }
        return Optional.empty();
    }

    private static int decrement(int maxRecursion, TypeMarker<?> originalType) {
        if (maxRecursion <= 0) {
            throw new SafeIllegalStateException("Unable to construct an empty instance as @JsonCreator requires too much recursion", SafeArg.of("type", originalType));
        }
        return maxRecursion - 1;
    }

    private static Optional<Object> coerceCollections(Type type) {
        ParameterizedType parameterizedType;
        Type raw;
        if (type instanceof Class) {
            return JacksonEmptyContainerLoader.coerceCollections((Class)type);
        }
        if (type instanceof ParameterizedType && (raw = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return JacksonEmptyContainerLoader.coerceCollections((Class)raw);
        }
        return Optional.empty();
    }

    private static Optional<Object> coerceCollections(Class<?> clazz) {
        if (List.class.isAssignableFrom(clazz)) {
            return Optional.of(Collections.emptyList());
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return Optional.of(Collections.emptySet());
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.empty();
    }

    private Optional<Object> jacksonDeserializeFromNull(Type type) {
        try {
            return Optional.ofNullable(this.mapper.readerFor(this.mapper.getTypeFactory().constructType(type)).readValue(this.mapper.nullNode()));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    @Nullable
    private static Method getJsonCreatorStaticMethod(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            for (Method method : clazz.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 1 || method.getAnnotation(JsonCreator.class) == null) continue;
                return method;
            }
        }
        return null;
    }

    private static Optional<Object> invokeStaticFactoryMethod(Method method, Object parameter) {
        try {
            return Optional.ofNullable(method.invoke(null, parameter));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (log.isDebugEnabled()) {
                log.debug("Reflection instantiation failed", e);
            }
            return Optional.empty();
        }
    }
}

