/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.conjure.java.dialogue.serde.Encoding;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.com.palantir.tracing.Tracer;

final class TracedEncoding
implements Encoding {
    private final Encoding delegate;

    TracedEncoding(Encoding delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "Encoding is required");
    }

    @Override
    public <T> Encoding.Serializer<T> serializer(TypeMarker<T> type) {
        return new TracedSerializer<T>(this.delegate.serializer(type), "Dialogue: serialize", ImmutableMap.of("type", TracedEncoding.toString(type), "contentType", this.getContentType()));
    }

    @Override
    public <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
        return new TracedDeserializer<T>(this.delegate.deserializer(type), "Dialogue: deserialize", ImmutableMap.of("type", TracedEncoding.toString(type), "contentType", this.getContentType()));
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public boolean supportsContentType(String contentType) {
        return this.delegate.supportsContentType(contentType);
    }

    public String toString() {
        return "TracedEncoding{" + this.delegate + "}";
    }

    static String toString(TypeMarker<?> typeMarker) {
        Type type = typeMarker.getType();
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.toString();
    }

    private static final class TracedDeserializer<T>
    implements Encoding.Deserializer<T> {
        private static final SafeLogger log = SafeLoggerFactory.get(TracedDeserializer.class);
        private final Encoding.Deserializer<T> delegate;
        private final String operation;
        private final ImmutableMap<String, String> tags;

        TracedDeserializer(Encoding.Deserializer<T> delegate, String operation, ImmutableMap<String, String> tags) {
            this.delegate = delegate;
            this.operation = operation;
            this.tags = tags;
        }

        @Override
        public T deserialize(InputStream input) throws IOException {
            if (log.isDebugEnabled()) {
                Tracer.fastStartSpan(this.operation);
                try {
                    T t = this.delegate.deserialize(input);
                    return t;
                }
                finally {
                    Tracer.fastCompleteSpan(this.tags);
                }
            }
            return this.delegate.deserialize(input);
        }

        public String toString() {
            return "TracedDeserializer{delegate=" + this.delegate + ", operation='" + this.operation + "', tags=" + this.tags + "}";
        }
    }

    private static final class TracedSerializer<T>
    implements Encoding.Serializer<T> {
        private static final SafeLogger log = SafeLoggerFactory.get(TracedSerializer.class);
        private final Encoding.Serializer<T> delegate;
        private final String operation;
        private final ImmutableMap<String, String> tags;

        TracedSerializer(Encoding.Serializer<T> delegate, String operation, ImmutableMap<String, String> tags) {
            this.delegate = delegate;
            this.operation = operation;
            this.tags = tags;
        }

        @Override
        public void serialize(T value, OutputStream output) throws IOException {
            if (log.isDebugEnabled()) {
                Tracer.fastStartSpan(this.operation);
                try {
                    this.delegate.serialize(value, output);
                }
                finally {
                    Tracer.fastCompleteSpan(this.tags);
                }
            } else {
                this.delegate.serialize(value, output);
            }
        }

        public String toString() {
            return "TracedSerializer{delegate=" + this.delegate + ", operation='" + this.operation + "'}";
        }
    }
}

