/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.lib.internal;

import com.palantir.logsafe.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureBooleanList;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureDoubleList;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureIntegerList;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureSafeLongList;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import shadow.palantir.driver.org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;

public final class ConjureCollections {
    private ConjureCollections() {
    }

    public static <T> void addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        Preconditions.checkNotNull(elementsToAdd, "elementsToAdd cannot be null");
        if (elementsToAdd instanceof Collection) {
            addTo.addAll((Collection)elementsToAdd);
        } else {
            for (T element : elementsToAdd) {
                addTo.add(element);
            }
        }
    }

    public static <T> void addAllAndCheckNonNull(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        Preconditions.checkNotNull(elementsToAdd, "elementsToAdd cannot be null");
        if (elementsToAdd instanceof Collection) {
            Collection collectionElementsToAdd = (Collection)elementsToAdd;
            if (addTo instanceof ArrayList) {
                ((ArrayList)addTo).ensureCapacity(collectionElementsToAdd.size() + addTo.size());
            }
        }
        for (T element : elementsToAdd) {
            Preconditions.checkNotNull(element, "elementsToAdd cannot contain null elements");
            addTo.add(element);
        }
    }

    public static <T> ArrayList<T> newArrayList(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable, "iterable cannot be null");
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable, "iterable cannot be null");
        if (iterable instanceof Collection) {
            return new LinkedHashSet((Collection)iterable);
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T item : iterable) {
            set.add(item);
        }
        return set;
    }

    public static <T> List<T> newList() {
        return new ArrayList();
    }

    public static <T> List<T> newList(Iterable<? extends T> iterable) {
        return ConjureCollections.newArrayList(iterable);
    }

    public static <T> List<T> newNonNullList() {
        return new ArrayList();
    }

    public static <T> List<T> newNonNullList(Iterable<? extends T> iterable) {
        List<T> arrayList = ConjureCollections.newList(iterable);
        for (T item : arrayList) {
            Preconditions.checkNotNull(item, "iterable cannot contain null elements");
        }
        return arrayList;
    }

    public static <T> Set<T> newSet() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> newSet(Iterable<? extends T> iterable) {
        return ConjureCollections.newLinkedHashSet(iterable);
    }

    public static <T> Set<T> newNonNullSet() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> newNonNullSet(Iterable<? extends T> iterable) {
        Set<T> set = ConjureCollections.newSet(iterable);
        for (T item : set) {
            Preconditions.checkNotNull(item, "iterable cannot contain null elements");
        }
        return set;
    }

    public static List<Double> newNonNullDoubleList() {
        return new ConjureDoubleList(new DoubleArrayList());
    }

    public static List<Double> newNonNullDoubleList(Iterable<Double> iterable) {
        ConjureDoubleList doubleList = iterable instanceof Collection ? new ConjureDoubleList(new DoubleArrayList(((Collection)iterable).size())) : new ConjureDoubleList(new DoubleArrayList());
        ConjureCollections.addAll(doubleList, iterable);
        return doubleList;
    }

    public static List<Integer> newNonNullIntegerList() {
        return new ConjureIntegerList(new IntArrayList());
    }

    public static List<Integer> newNonNullIntegerList(Iterable<Integer> iterable) {
        ConjureIntegerList integerList = iterable instanceof Collection ? new ConjureIntegerList(new IntArrayList(((Collection)iterable).size())) : new ConjureIntegerList(new IntArrayList());
        ConjureCollections.addAll(integerList, iterable);
        return integerList;
    }

    public static List<Boolean> newNonNullBooleanList() {
        return new ConjureBooleanList(new BooleanArrayList());
    }

    public static List<Boolean> newNonNullBooleanList(Iterable<Boolean> iterable) {
        ConjureBooleanList booleanList = iterable instanceof Collection ? new ConjureBooleanList(new BooleanArrayList(((Collection)iterable).size())) : new ConjureBooleanList(new BooleanArrayList());
        ConjureCollections.addAll(booleanList, iterable);
        return booleanList;
    }

    public static List<SafeLong> newNonNullSafeLongList() {
        return new ConjureSafeLongList(new LongArrayList());
    }

    public static List<SafeLong> newNonNullSafeLongList(Iterable<SafeLong> iterable) {
        ConjureSafeLongList safeLongList = iterable instanceof Collection ? new ConjureSafeLongList(new LongArrayList(((Collection)iterable).size())) : new ConjureSafeLongList(new LongArrayList());
        ConjureCollections.addAll(safeLongList, iterable);
        return safeLongList;
    }
}

