/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.serialization;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import shadow.palantir.driver.com.fasterxml.jackson.core.Base64Variant;
import shadow.palantir.driver.com.fasterxml.jackson.core.FormatSchema;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonFactory;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonFactoryBuilder;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonLocation;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonStreamContext;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.core.ObjectCodec;
import shadow.palantir.driver.com.fasterxml.jackson.core.SerializableString;
import shadow.palantir.driver.com.fasterxml.jackson.core.StreamReadCapability;
import shadow.palantir.driver.com.fasterxml.jackson.core.StreamReadFeature;
import shadow.palantir.driver.com.fasterxml.jackson.core.TreeNode;
import shadow.palantir.driver.com.fasterxml.jackson.core.Version;
import shadow.palantir.driver.com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import shadow.palantir.driver.com.fasterxml.jackson.core.io.IOContext;
import shadow.palantir.driver.com.fasterxml.jackson.core.type.TypeReference;
import shadow.palantir.driver.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import shadow.palantir.driver.com.fasterxml.jackson.core.util.RequestPayload;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.ParserInstrumentation;
import shadow.palantir.driver.javax.annotation.Nullable;

final class InstrumentedJsonFactory
extends JsonFactory {
    private final ParserInstrumentation instrumentation;

    InstrumentedJsonFactory() {
        this.instrumentation = new ParserInstrumentation(this.getFormatName());
    }

    private InstrumentedJsonFactory(JsonFactoryBuilder builder) {
        this(builder, new ParserInstrumentation("JSON"));
    }

    private InstrumentedJsonFactory(JsonFactoryBuilder builder, ParserInstrumentation instrumentation) {
        super(builder);
        this.instrumentation = instrumentation;
    }

    private InstrumentedJsonFactory(JsonFactory src, @Nullable ObjectCodec codec, ParserInstrumentation instrumentation) {
        super(src, codec);
        this.instrumentation = instrumentation;
    }

    public static JsonFactoryBuilder builder() {
        return new JsonFactoryBuilder(){

            @Override
            public JsonFactory build() {
                return new InstrumentedJsonFactory(this);
            }
        };
    }

    public JsonFactoryBuilder rebuild() {
        return new JsonFactoryBuilder(this){

            @Override
            public JsonFactory build() {
                return new InstrumentedJsonFactory(this, InstrumentedJsonFactory.this.instrumentation);
            }
        };
    }

    @Override
    public JsonFactory copy() {
        return new InstrumentedJsonFactory(this, null, this.instrumentation);
    }

    @Override
    public String getFormatName() {
        return "JSON";
    }

    @Override
    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(in, ctxt));
    }

    @Override
    protected JsonParser _createParser(Reader reader, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(reader, ctxt));
    }

    @Override
    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return this.wrap(super._createParser(data, offset, len, ctxt, recyclable));
    }

    @Override
    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(data, offset, len, ctxt));
    }

    @Override
    protected JsonParser _createParser(DataInput input, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(input, ctxt));
    }

    private JsonParser wrap(JsonParser input) {
        if (input == null || input instanceof InstrumentedJsonParser) {
            return input;
        }
        return new InstrumentedJsonParser(input, this.instrumentation);
    }

    private static final class InstrumentedJsonParser
    extends JsonParser {
        private final JsonParser delegate;
        private final ParserInstrumentation instrumentation;

        InstrumentedJsonParser(JsonParser delegate, ParserInstrumentation instrumentation) {
            this.delegate = delegate;
            this.instrumentation = instrumentation;
        }

        @Override
        public ObjectCodec getCodec() {
            return this.delegate.getCodec();
        }

        @Override
        public void setCodec(ObjectCodec oc) {
            this.delegate.setCodec(oc);
        }

        @Override
        public Object getInputSource() {
            return this.delegate.getInputSource();
        }

        @Override
        public void setRequestPayloadOnError(RequestPayload payload) {
            this.delegate.setRequestPayloadOnError(payload);
        }

        @Override
        public void setRequestPayloadOnError(byte[] payload, String charset) {
            this.delegate.setRequestPayloadOnError(payload, charset);
        }

        @Override
        public void setRequestPayloadOnError(String payload) {
            this.delegate.setRequestPayloadOnError(payload);
        }

        @Override
        public void setSchema(FormatSchema schema) {
            this.delegate.setSchema(schema);
        }

        @Override
        public FormatSchema getSchema() {
            return this.delegate.getSchema();
        }

        @Override
        public boolean canUseSchema(FormatSchema schema) {
            return this.delegate.canUseSchema(schema);
        }

        @Override
        public boolean requiresCustomCodec() {
            return this.delegate.requiresCustomCodec();
        }

        @Override
        public boolean canParseAsync() {
            return this.delegate.canParseAsync();
        }

        @Override
        public NonBlockingInputFeeder getNonBlockingInputFeeder() {
            return this.delegate.getNonBlockingInputFeeder();
        }

        @Override
        public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
            return this.delegate.getReadCapabilities();
        }

        @Override
        public Version version() {
            return this.delegate.version();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public JsonStreamContext getParsingContext() {
            return this.delegate.getParsingContext();
        }

        @Override
        public JsonLocation currentLocation() {
            return this.delegate.currentLocation();
        }

        @Override
        public JsonLocation currentTokenLocation() {
            return this.delegate.currentTokenLocation();
        }

        @Override
        public JsonLocation getCurrentLocation() {
            return this.delegate.getCurrentLocation();
        }

        @Override
        public JsonLocation getTokenLocation() {
            return this.delegate.getTokenLocation();
        }

        @Override
        public Object currentValue() {
            return this.delegate.currentValue();
        }

        @Override
        public void assignCurrentValue(Object value) {
            this.delegate.assignCurrentValue(value);
        }

        @Override
        public Object getCurrentValue() {
            return this.delegate.getCurrentValue();
        }

        @Override
        public void setCurrentValue(Object value) {
            this.delegate.setCurrentValue(value);
        }

        @Override
        public int releaseBuffered(OutputStream out) throws IOException {
            return this.delegate.releaseBuffered(out);
        }

        @Override
        public int releaseBuffered(Writer writer) throws IOException {
            return this.delegate.releaseBuffered(writer);
        }

        @Override
        public JsonParser enable(JsonParser.Feature feature) {
            this.delegate.enable(feature);
            return this;
        }

        @Override
        public JsonParser disable(JsonParser.Feature feature) {
            this.delegate.disable(feature);
            return this;
        }

        @Override
        public JsonParser configure(JsonParser.Feature feature, boolean state) {
            this.delegate.configure(feature, state);
            return this;
        }

        @Override
        public boolean isEnabled(JsonParser.Feature feature) {
            return this.delegate.isEnabled(feature);
        }

        @Override
        public boolean isEnabled(StreamReadFeature feature) {
            return this.delegate.isEnabled(feature);
        }

        @Override
        public int getFeatureMask() {
            return this.delegate.getFeatureMask();
        }

        @Override
        @Deprecated
        public JsonParser setFeatureMask(int mask) {
            this.delegate.setFeatureMask(mask);
            return this;
        }

        @Override
        public JsonParser overrideStdFeatures(int values, int mask) {
            this.delegate.overrideStdFeatures(values, mask);
            return this;
        }

        @Override
        public int getFormatFeatures() {
            return this.delegate.getFormatFeatures();
        }

        @Override
        public JsonParser overrideFormatFeatures(int values, int mask) {
            this.delegate.overrideFormatFeatures(values, mask);
            return this;
        }

        @Override
        public JsonToken nextToken() throws IOException {
            return this.delegate.nextToken();
        }

        @Override
        public JsonToken nextValue() throws IOException {
            return this.delegate.nextValue();
        }

        @Override
        public boolean nextFieldName(SerializableString str) throws IOException {
            return this.delegate.nextFieldName(str);
        }

        @Override
        public String nextFieldName() throws IOException {
            return this.delegate.nextFieldName();
        }

        @Override
        public String nextTextValue() throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.nextTextValue());
        }

        @Override
        public int nextIntValue(int defaultValue) throws IOException {
            return this.delegate.nextIntValue(defaultValue);
        }

        @Override
        public long nextLongValue(long defaultValue) throws IOException {
            return this.delegate.nextLongValue(defaultValue);
        }

        @Override
        public Boolean nextBooleanValue() throws IOException {
            return this.delegate.nextBooleanValue();
        }

        @Override
        public JsonParser skipChildren() throws IOException {
            this.delegate.skipChildren();
            return this;
        }

        @Override
        public void finishToken() throws IOException {
            this.delegate.finishToken();
        }

        @Override
        public JsonToken currentToken() {
            return this.delegate.currentToken();
        }

        @Override
        public int currentTokenId() {
            return this.delegate.currentTokenId();
        }

        @Override
        public JsonToken getCurrentToken() {
            return this.delegate.getCurrentToken();
        }

        @Override
        @Deprecated
        public int getCurrentTokenId() {
            return this.delegate.getCurrentTokenId();
        }

        @Override
        public boolean hasCurrentToken() {
            return this.delegate.hasCurrentToken();
        }

        @Override
        public boolean hasTokenId(int id) {
            return this.delegate.hasTokenId(id);
        }

        @Override
        public boolean hasToken(JsonToken token) {
            return this.delegate.hasToken(token);
        }

        @Override
        public boolean isExpectedStartArrayToken() {
            return this.delegate.isExpectedStartArrayToken();
        }

        @Override
        public boolean isExpectedStartObjectToken() {
            return this.delegate.isExpectedStartObjectToken();
        }

        @Override
        public boolean isExpectedNumberIntToken() {
            return this.delegate.isExpectedNumberIntToken();
        }

        @Override
        public boolean isNaN() throws IOException {
            return this.delegate.isNaN();
        }

        @Override
        public void clearCurrentToken() {
            this.delegate.clearCurrentToken();
        }

        @Override
        public JsonToken getLastClearedToken() {
            return this.delegate.getLastClearedToken();
        }

        @Override
        public void overrideCurrentName(String name) {
            this.delegate.overrideCurrentName(name);
        }

        @Override
        public String getCurrentName() throws IOException {
            return this.delegate.getCurrentName();
        }

        @Override
        public String currentName() throws IOException {
            return this.delegate.currentName();
        }

        @Override
        public String getText() throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.getText());
        }

        @Override
        public int getText(Writer writer) throws IOException, UnsupportedOperationException {
            return this.delegate.getText(writer);
        }

        @Override
        public char[] getTextCharacters() throws IOException {
            return this.delegate.getTextCharacters();
        }

        @Override
        public int getTextLength() throws IOException {
            return this.delegate.getTextLength();
        }

        @Override
        public int getTextOffset() throws IOException {
            return this.delegate.getTextOffset();
        }

        @Override
        public boolean hasTextCharacters() {
            return this.delegate.hasTextCharacters();
        }

        @Override
        public Number getNumberValue() throws IOException {
            return this.delegate.getNumberValue();
        }

        @Override
        public Number getNumberValueExact() throws IOException {
            return this.delegate.getNumberValueExact();
        }

        @Override
        public JsonParser.NumberType getNumberType() throws IOException {
            return this.delegate.getNumberType();
        }

        @Override
        public byte getByteValue() throws IOException {
            return this.delegate.getByteValue();
        }

        @Override
        public short getShortValue() throws IOException {
            return this.delegate.getShortValue();
        }

        @Override
        public int getIntValue() throws IOException {
            return this.delegate.getIntValue();
        }

        @Override
        public long getLongValue() throws IOException {
            return this.delegate.getLongValue();
        }

        @Override
        public BigInteger getBigIntegerValue() throws IOException {
            return this.delegate.getBigIntegerValue();
        }

        @Override
        public float getFloatValue() throws IOException {
            return this.delegate.getFloatValue();
        }

        @Override
        public double getDoubleValue() throws IOException {
            return this.delegate.getDoubleValue();
        }

        @Override
        public BigDecimal getDecimalValue() throws IOException {
            return this.delegate.getDecimalValue();
        }

        @Override
        public boolean getBooleanValue() throws IOException {
            return this.delegate.getBooleanValue();
        }

        @Override
        public Object getEmbeddedObject() throws IOException {
            return this.delegate.getEmbeddedObject();
        }

        @Override
        public byte[] getBinaryValue(Base64Variant bv) throws IOException {
            return this.delegate.getBinaryValue(bv);
        }

        @Override
        public byte[] getBinaryValue() throws IOException {
            return this.delegate.getBinaryValue();
        }

        @Override
        public int readBinaryValue(OutputStream out) throws IOException {
            return this.delegate.readBinaryValue(out);
        }

        @Override
        public int readBinaryValue(Base64Variant bv, OutputStream out) throws IOException {
            return this.delegate.readBinaryValue(bv, out);
        }

        @Override
        public int getValueAsInt() throws IOException {
            return this.delegate.getValueAsInt();
        }

        @Override
        public int getValueAsInt(int def) throws IOException {
            return this.delegate.getValueAsInt(def);
        }

        @Override
        public long getValueAsLong() throws IOException {
            return this.delegate.getValueAsLong();
        }

        @Override
        public long getValueAsLong(long def) throws IOException {
            return this.delegate.getValueAsLong(def);
        }

        @Override
        public double getValueAsDouble() throws IOException {
            return this.delegate.getValueAsDouble();
        }

        @Override
        public double getValueAsDouble(double def) throws IOException {
            return this.delegate.getValueAsDouble(def);
        }

        @Override
        public boolean getValueAsBoolean() throws IOException {
            return this.delegate.getValueAsBoolean();
        }

        @Override
        public boolean getValueAsBoolean(boolean def) throws IOException {
            return this.delegate.getValueAsBoolean(def);
        }

        @Override
        public String getValueAsString() throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.getValueAsString());
        }

        @Override
        public String getValueAsString(String def) throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.getValueAsString(def));
        }

        @Override
        public boolean canReadObjectId() {
            return this.delegate.canReadObjectId();
        }

        @Override
        public boolean canReadTypeId() {
            return this.delegate.canReadTypeId();
        }

        @Override
        public Object getObjectId() throws IOException {
            return this.delegate.getObjectId();
        }

        @Override
        public Object getTypeId() throws IOException {
            return this.delegate.getTypeId();
        }

        @Override
        public <T> T readValueAs(Class<T> valueType) throws IOException {
            return this.delegate.readValueAs(valueType);
        }

        @Override
        public <T> T readValueAs(TypeReference<?> valueTypeRef) throws IOException {
            return this.delegate.readValueAs(valueTypeRef);
        }

        @Override
        public <T> Iterator<T> readValuesAs(Class<T> valueType) throws IOException {
            return this.delegate.readValuesAs(valueType);
        }

        @Override
        public <T> Iterator<T> readValuesAs(TypeReference<T> valueTypeRef) throws IOException {
            return this.delegate.readValuesAs(valueTypeRef);
        }

        @Override
        public <T extends TreeNode> T readValueAsTree() throws IOException {
            return this.delegate.readValueAsTree();
        }

        @Override
        public ObjectCodec _codec() {
            ObjectCodec codec = this.delegate.getCodec();
            if (codec == null) {
                throw new SafeIllegalStateException("No ObjectCodec defined for parser, needed for deserialization", new Arg[0]);
            }
            return codec;
        }
    }
}

