/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.serialization;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Histogram;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class JsonParserMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "conjure-java-runtime";
    private static final String LIBRARY_VERSION = "8.15.0";
    private final TaggedMetricRegistry registry;

    private JsonParserMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static JsonParserMetrics of(TaggedMetricRegistry registry) {
        return new JsonParserMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    Histogram stringLength(@Safe String format) {
        return this.registry.histogram(JsonParserMetrics.stringLengthMetricName(format));
    }

    static MetricName stringLengthMetricName(@Safe String format) {
        return MetricName.builder().safeName("json.parser.string.length").putSafeTags("format", format).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    public String toString() {
        return "JsonParserMetrics{registry=" + this.registry + "}";
    }
}

