/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.serialization;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIoException;
import java.io.IOException;
import java.util.OptionalLong;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.cfg.CoercionAction;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import shadow.palantir.driver.com.fasterxml.jackson.databind.module.SimpleModule;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.jdk8.OptionalLongDeserializer;

final class LenientLongModule
extends SimpleModule {
    LenientLongModule() {
        super("lenient long");
        this.addDeserializer(Long.TYPE, new LongAsStringDeserializer()).addDeserializer(Long.class, new LongAsStringDeserializer()).addDeserializer(OptionalLong.class, new OptionalLongAsStringDeserializer());
    }

    private static final class OptionalLongAsStringDeserializer
    extends OptionalLongDeserializer {
        private OptionalLongAsStringDeserializer() {
        }

        @Override
        protected CoercionAction _checkFromStringCoercion(DeserializationContext _ctxt, String _value) {
            return CoercionAction.TryConvert;
        }
    }

    private static final class LongAsStringDeserializer
    extends StdDeserializer<Long> {
        private LongAsStringDeserializer() {
            super(Long.TYPE);
        }

        @Override
        public Long deserialize(JsonParser jsonParser, DeserializationContext _ctxt) throws IOException {
            switch (jsonParser.currentToken()) {
                case VALUE_NUMBER_INT: {
                    return jsonParser.getLongValue();
                }
                case VALUE_STRING: {
                    return LongAsStringDeserializer.parseLong(jsonParser);
                }
                case VALUE_NULL: {
                    return null;
                }
            }
            throw new SafeIoException("Expected a long value", new Arg[0]);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        private static Long parseLong(JsonParser jsonParser) throws IOException {
            String value = jsonParser.getValueAsString();
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                InvalidFormatException failure = new InvalidFormatException(jsonParser, "not a valid long value", (Object)value, Long.TYPE);
                failure.initCause(e);
                throw failure;
            }
        }
    }
}

