/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.serialization;

import shadow.palantir.driver.com.fasterxml.jackson.core.JsonFactory;
import shadow.palantir.driver.com.fasterxml.jackson.core.StreamReadConstraints;
import shadow.palantir.driver.com.fasterxml.jackson.core.TSFBuilder;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.MapperFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializationFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.cfg.MapperBuilder;
import shadow.palantir.driver.com.fasterxml.jackson.databind.json.JsonMapper;
import shadow.palantir.driver.com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import shadow.palantir.driver.com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import shadow.palantir.driver.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import shadow.palantir.driver.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.dataformat.smile.databind.SmileMapper;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.guava.GuavaModule;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.joda.JodaModule;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import shadow.palantir.driver.com.palantir.conjure.java.jackson.optimizations.ObjectMapperOptimizations;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.InstrumentedJsonFactory;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.InstrumentedSmileFactory;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.LenientLongModule;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.NonCachingTypeFactory;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.ShimJdk7Module;

public final class ObjectMappers {
    private ObjectMappers() {
    }

    public static JsonMapper newClientJsonMapper() {
        return (JsonMapper)((JsonMapper.Builder)ObjectMappers.withDefaultModules(JsonMapper.builder(ObjectMappers.jsonFactory())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).build();
    }

    public static CBORMapper newClientCborMapper() {
        return (CBORMapper)((CBORMapper.Builder)ObjectMappers.withDefaultModules(CBORMapper.builder(ObjectMappers.cborFactory())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).build();
    }

    public static SmileMapper newClientSmileMapper() {
        return (SmileMapper)((SmileMapper.Builder)ObjectMappers.withDefaultModules(SmileMapper.builder(ObjectMappers.smileFactory())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).build();
    }

    public static JsonMapper newServerJsonMapper() {
        return (JsonMapper)((JsonMapper.Builder)ObjectMappers.withDefaultModules(JsonMapper.builder(ObjectMappers.jsonFactory())).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).build();
    }

    public static CBORMapper newServerCborMapper() {
        return (CBORMapper)((CBORMapper.Builder)ObjectMappers.withDefaultModules(CBORMapper.builder(ObjectMappers.cborFactory())).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).build();
    }

    public static SmileMapper newServerSmileMapper() {
        return (SmileMapper)((SmileMapper.Builder)ObjectMappers.withDefaultModules(SmileMapper.builder(ObjectMappers.smileFactory())).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).build();
    }

    public static ObjectMapper newClientObjectMapper() {
        return ObjectMappers.newClientJsonMapper();
    }

    public static ObjectMapper newCborClientObjectMapper() {
        return ObjectMappers.newClientCborMapper();
    }

    public static ObjectMapper newSmileClientObjectMapper() {
        return ObjectMappers.newClientSmileMapper();
    }

    public static ObjectMapper newServerObjectMapper() {
        return ObjectMappers.newServerJsonMapper();
    }

    public static ObjectMapper newCborServerObjectMapper() {
        return ObjectMappers.newServerCborMapper();
    }

    public static ObjectMapper newSmileServerObjectMapper() {
        return ObjectMappers.newServerSmileMapper();
    }

    public static <M extends ObjectMapper, B extends MapperBuilder<M, B>> B withDefaultModules(B builder) {
        return ((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)builder.typeFactory(NonCachingTypeFactory.from(((ObjectMapper)builder.build()).getTypeFactory()))).addModule(new GuavaModule())).addModule(new ShimJdk7Module())).addModule(new Jdk8Module().configureAbsentsAsNulls(true))).addModules(ObjectMapperOptimizations.createModules())).addModule(new JavaTimeModule())).addModule(new LenientLongModule())).addModule(new JodaModule())).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS)).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE)).disable(DeserializationFeature.WRAP_EXCEPTIONS)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)).disable(MapperFeature.ALLOW_COERCION_OF_SCALARS)).disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT);
    }

    public static ObjectMapper withDefaultModules(ObjectMapper mapper) {
        return mapper.setTypeFactory(NonCachingTypeFactory.from(mapper.getTypeFactory())).registerModule(new GuavaModule()).registerModule(new ShimJdk7Module()).registerModule(new Jdk8Module().configureAbsentsAsNulls(true)).registerModules(ObjectMapperOptimizations.createModules()).registerModule(new JavaTimeModule()).registerModule(new LenientLongModule()).registerModule(new JodaModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).disable(DeserializationFeature.WRAP_EXCEPTIONS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).disable(MapperFeature.ALLOW_COERCION_OF_SCALARS).disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT);
    }

    public static JsonFactory jsonFactory() {
        return ObjectMappers.withDefaults(InstrumentedJsonFactory.builder()).build();
    }

    public static SmileFactory smileFactory() {
        return ObjectMappers.withDefaults(InstrumentedSmileFactory.builder().disable(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT)).build();
    }

    public static CBORFactory cborFactory() {
        return ObjectMappers.withDefaults(CBORFactory.builder()).build();
    }

    private static <F extends JsonFactory, B extends TSFBuilder<F, B>> B withDefaults(B builder) {
        return ((TSFBuilder)((TSFBuilder)builder.disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).streamReadConstraints(StreamReadConstraints.builder().maxStringLength(50000000).build());
    }
}

