/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.serialization;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;

public final class PathDeserializer
extends StdScalarDeserializer<Path> {
    private static final long serialVersionUID = 1L;

    public PathDeserializer() {
        super(Path.class);
    }

    @Override
    public Path deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token != null && token.isScalarValue()) {
            return Paths.get(parser.getValueAsString(), new String[0]);
        }
        throw new SafeJsonMappingException("Could not deserialize path", parser, ctxt.wrongTokenException(parser, Path.class, token, null));
    }

    private static final class SafeJsonMappingException
    extends JsonMappingException
    implements SafeLoggable {
        private final String logMessage;

        SafeJsonMappingException(@CompileTimeConstant String message, JsonParser parser, JsonMappingException cause) {
            super((Closeable)parser, message, (Throwable)cause);
            this.logMessage = message;
        }

        @Override
        public String getLogMessage() {
            return this.logMessage;
        }

        @Override
        public List<Arg<?>> getArgs() {
            return List.of();
        }
    }
}

