/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Unsafe;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import shadow.palantir.driver.com.palantir.contour.ipc.ImmutableArrowStreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.StreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.TableLatitudeResultMetadata;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ArrowRowIterator;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ArrowSchemaUtils;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterable;
import shadow.palantir.driver.com.palantir.contour.ipc.util.OneShotIterable;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Schema;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@Value.Immutable
public abstract class ArrowStreamingTableLatitudeResult
extends StreamingTableLatitudeResult {
    public abstract Iterable<byte[]> getArrowBatches();

    @Override
    protected final CloseableIterable<LatitudeRow> rowIterable() {
        Schema arrowSchema = ArrowSchemaUtils.toArrowSchema(TableLatitudeResultMetadata.from(this));
        try {
            return new OneShotIterable<LatitudeRow>(ArrowRowIterator.create(arrowSchema, this.getArrowBatches().iterator()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final <T> T accept(StreamingTableLatitudeResult.Visitor<T> visitor) {
        return visitor.visitArrowStreamingTableLatitudeResult(this);
    }

    public static ArrowStreamingTableLatitudeResult of(TableLatitudeResultMetadata metadata, Iterable<byte[]> arrowBatches) {
        ZonedDateTime computedTime = Instant.ofEpochMilli(metadata.getComputedTime().getMillis()).atZone(ZoneId.of(metadata.getComputedTime().getZone().getID(), ZoneId.SHORT_IDS));
        return ImmutableArrowStreamingTableLatitudeResult.builder().computedTime(computedTime).computedVersion(metadata.getComputedVersion()).warningMessage(metadata.getWarningMessage()).resultComputationMetadata(metadata.getResultComputationMetadata()).resultId(metadata.getResultId()).rowCount(metadata.getRowCount()).primaryKeyInformation(metadata.getPrimaryKeyInformation()).columns(metadata.getColumns()).columnTypes(metadata.getColumnTypes()).arrowBatches(arrowBatches).build();
    }
}

