/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import latitude.api.jackson.ContourJackson;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializationFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import shadow.palantir.driver.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import shadow.palantir.driver.com.fasterxml.jackson.databind.module.SimpleModule;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import shadow.palantir.driver.com.fasterxml.jackson.module.scala.introspect.ScalaAnnotationIntrospector$;
import shadow.palantir.driver.com.palantir.contour.ipc.ContourIpcSerializationModule;
import shadow.palantir.driver.com.palantir.contour.ipc.IgnoreResultsIntrospector;

public final class ContourIpcJackson {
    public static final ObjectMapper OBJECT_MAPPER = ContourIpcJackson.newObjectMapper();
    static final ObjectMapper IGNORE_RESULTS_OBJECT_MAPPER = ContourIpcJackson.newIgnoreResultsObjectMapper();

    private static ObjectMapper newObjectMapper() {
        return ContourJackson.getNewStandaloneObjectMapper().registerModule(new ContourIpcSerializationModule()).registerModule(new SimpleModule(){
            {
                DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
                this.addSerializer(LocalDate.class, new LocalDateSerializer(dateTimeFormatter));
                this.addDeserializer(LocalDate.class, new LocalDateDeserializer(dateTimeFormatter));
            }
        }).configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false).configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false).setAnnotationIntrospector(new AnnotationIntrospectorPair(ScalaAnnotationIntrospector$.MODULE$, new JacksonAnnotationIntrospector())).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
    }

    private static ObjectMapper newIgnoreResultsObjectMapper() {
        return ContourIpcJackson.newObjectMapper().setAnnotationIntrospector(new AnnotationIntrospectorPair(ScalaAnnotationIntrospector$.MODULE$, new IgnoreResultsIntrospector()));
    }

    private ContourIpcJackson() {
    }
}

