/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.Optional;
import latitude.api.results.LatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeResultWrapper;
import shadow.palantir.driver.com.palantir.contour.ipc.StreamingTableLatitudeResult;

final class DefaultLatitudeResultWrapper
implements LatitudeResultWrapper {
    private final Optional<? extends LatitudeResult> latitudeResult;
    private final Optional<StreamingTableLatitudeResult> streamingTableLatitudeResult;

    DefaultLatitudeResultWrapper(Optional<? extends LatitudeResult> latitudeResult, Optional<StreamingTableLatitudeResult> streamingTableLatitudeResult) {
        this.latitudeResult = latitudeResult;
        this.streamingTableLatitudeResult = streamingTableLatitudeResult;
    }

    @Override
    public <T> T accept(LatitudeResultWrapper.Visitor<T> visitor) {
        if (this.latitudeResult.isPresent()) {
            return visitor.visitLatitudeResult(this.latitudeResult.get());
        }
        if (this.streamingTableLatitudeResult.isPresent()) {
            return visitor.visitStreamingTableLatitudeResult(this.streamingTableLatitudeResult.get());
        }
        throw new SafeIllegalStateException("LatitudeResultWrapper has no result", new Arg[0]);
    }

    @Override
    public <T, E extends Exception> T accept(LatitudeResultWrapper.ThrowingVisitor<T, E> visitor) throws E {
        if (this.latitudeResult.isPresent()) {
            return visitor.visitLatitudeResult(this.latitudeResult.get());
        }
        if (this.streamingTableLatitudeResult.isPresent()) {
            return visitor.visitStreamingTableLatitudeResult(this.streamingTableLatitudeResult.get());
        }
        throw new SafeIllegalStateException("LatitudeResultWrapper has no result", new Arg[0]);
    }

    @Override
    public LatitudeResult asLatitudeResult() {
        return this.accept(new LatitudeResultWrapper.Visitor<LatitudeResult>(){

            @Override
            public LatitudeResult visitLatitudeResult(LatitudeResult result) {
                return result;
            }

            @Override
            public LatitudeResult visitStreamingTableLatitudeResult(StreamingTableLatitudeResult result) {
                return result.asLatitudeResult();
            }
        });
    }
}

