/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.core.type.TypeReference;
import shadow.palantir.driver.com.google.common.collect.Maps;
import shadow.palantir.driver.com.palantir.contour.ipc.ContourIpcJackson;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeStruct;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;

public final class GenericLatitudeRow
extends LatitudeRow {
    private final List<Object> values;

    private GenericLatitudeRow(List<Object> values, List<FoundryFieldSchema> schema) {
        super(schema);
        this.values = values;
    }

    public static GenericLatitudeRow of(List<Object> values, List<FoundryFieldSchema> schema) {
        return new GenericLatitudeRow(values, schema);
    }

    public static GenericLatitudeRow copyOf(LatitudeRow other) {
        List<Object> values = IntStream.range(0, other.numFields()).mapToObj(other::get).collect(Collectors.toList());
        return new GenericLatitudeRow(values, other.getSchema());
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.values.get(ordinal) == null;
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return (byte[])this.getAs(ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return (Boolean)this.getAs(ordinal);
    }

    @Override
    public byte getByte(int ordinal) {
        return (Byte)this.getAs(ordinal);
    }

    @Override
    public LocalDate getDate(int ordinal) {
        return (LocalDate)this.getAs(ordinal);
    }

    @Override
    public BigDecimal getDecimal(int ordinal) {
        return (BigDecimal)this.getAs(ordinal);
    }

    @Override
    public double getDouble(int ordinal) {
        return (Double)this.getAs(ordinal);
    }

    @Override
    public float getFloat(int ordinal) {
        return ((Float)this.getAs(ordinal)).floatValue();
    }

    @Override
    public int getInteger(int ordinal) {
        return (Integer)this.getAs(ordinal);
    }

    @Override
    public long getLong(int ordinal) {
        return (Long)this.getAs(ordinal);
    }

    @Override
    public short getShort(int ordinal) {
        return (Short)this.getAs(ordinal);
    }

    @Override
    public String getString(int ordinal) {
        return (String)this.getAs(ordinal);
    }

    @Override
    public Instant getTimestamp(int ordinal) {
        return (Instant)this.getAs(ordinal);
    }

    @Override
    public List<Object> getArray(int ordinal) {
        return (List)this.getAs(ordinal);
    }

    @Override
    public Map<Object, Object> getMap(int ordinal) {
        return (Map)this.getAs(ordinal);
    }

    @Override
    public LatitudeStruct getStruct(int ordinal) {
        return (LatitudeStruct)this.getAs(ordinal);
    }

    @Override
    public Object getUdt(int ordinal) {
        return this.getAs(ordinal);
    }

    private <T> T getAs(int ordinal) {
        return (T)GenericLatitudeRow.convert(this.values.get(ordinal), this.getSchema().get(ordinal));
    }

    private static Object convert(final Object obj, final FoundryFieldSchema schema) {
        if (obj == null) {
            return null;
        }
        if (schema.getUserDefinedTypeClass().isPresent()) {
            return obj;
        }
        return schema.getType().accept(new FoundryFieldType.Visitor<Object>(){

            @Override
            public Object visitBinary() {
                if (obj instanceof byte[]) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, new TypeReference<byte[]>(){});
            }

            @Override
            public Object visitBoolean() {
                if (obj instanceof Boolean) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Boolean.class);
            }

            @Override
            public Object visitByte() {
                if (obj instanceof Byte) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Byte.class);
            }

            @Override
            public Object visitDate() {
                if (obj instanceof LocalDate) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, LocalDate.class);
            }

            @Override
            public Object visitDecimal() {
                if (obj instanceof BigDecimal) {
                    return obj;
                }
                if (obj instanceof Double) {
                    return BigDecimal.valueOf((Double)obj);
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, BigDecimal.class);
            }

            @Override
            public Object visitDouble() {
                if (obj instanceof Double) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Double.class);
            }

            @Override
            public Object visitFloat() {
                if (obj instanceof Float) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Float.class);
            }

            @Override
            public Object visitInteger() {
                if (obj instanceof Integer) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Integer.class);
            }

            @Override
            public Object visitLong() {
                if (obj instanceof Long) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Long.class);
            }

            @Override
            public Object visitShort() {
                if (obj instanceof Short) {
                    return obj;
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Short.class);
            }

            @Override
            public Object visitString() {
                return obj;
            }

            @Override
            public Object visitTimestamp() {
                if (obj instanceof Long) {
                    return Instant.ofEpochMilli((Long)obj);
                }
                if (obj instanceof Instant) {
                    return obj;
                }
                if (obj instanceof Timestamp) {
                    return ((Timestamp)obj).toInstant();
                }
                return ContourIpcJackson.OBJECT_MAPPER.convertValue(obj, Instant.class);
            }

            @Override
            public Object visitArray() {
                FoundryFieldSchema elementSchema = schema.getArraySubtype().orElseThrow(() -> new SafeIllegalStateException("Array type has no subtype", new Arg[0]));
                return ((List)obj).stream().map(element -> GenericLatitudeRow.convert(element, elementSchema)).collect(Collectors.toList());
            }

            @Override
            public Object visitMap() {
                FoundryFieldSchema keySchema = schema.getMapKeyType().orElseThrow(() -> new SafeIllegalStateException("Map type has no key type", new Arg[0]));
                FoundryFieldSchema valueSchema = schema.getMapValueType().orElseThrow(() -> new SafeIllegalStateException("Map type has no value type", new Arg[0]));
                Map map = (Map)obj;
                HashMap result = Maps.newHashMapWithExpectedSize(map.size());
                map.forEach((key, value) -> {
                    Object convertedKey = GenericLatitudeRow.convert(key, keySchema);
                    Object convertedValue = GenericLatitudeRow.convert(value, valueSchema);
                    if (result.containsKey(convertedKey)) {
                        throw new SafeIllegalStateException("Map type has duplicate keys.", UnsafeArg.of("key", convertedKey));
                    }
                    result.put(convertedKey, convertedValue);
                });
                return result;
            }

            @Override
            public Object visitStruct() {
                List values;
                List<FoundryFieldSchema> subSchemas = schema.getSubSchemas().orElseThrow(() -> new SafeIllegalStateException("Struct type has no subtypes", new Arg[0]));
                if (obj instanceof Map) {
                    Map struct = (Map)obj;
                    values = subSchemas.stream().map(FoundryFieldSchema::getName).map(Optional::get).map(struct::get).collect(Collectors.toList());
                } else {
                    LatitudeStruct struct = (LatitudeStruct)obj;
                    values = IntStream.range(0, subSchemas.size()).mapToObj(struct::get).collect(Collectors.toList());
                }
                return LatitudeStruct.of(GenericLatitudeRow.of(IntStream.range(0, subSchemas.size()).mapToObj(index -> GenericLatitudeRow.convert(values.get(index), (FoundryFieldSchema)subSchemas.get(index))).collect(Collectors.toList()), subSchemas));
            }

            @Override
            public Object visitUnknown(String unknownValue) {
                throw ContourExceptions.serverUnknownUnionType(unknownValue, FoundryFieldType.class);
            }
        });
    }
}

