/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeStruct;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class LatitudeRow {
    private final List<FoundryFieldSchema> schema;

    protected LatitudeRow(List<FoundryFieldSchema> schema) {
        this.schema = schema;
    }

    public final List<FoundryFieldSchema> getSchema() {
        return this.schema;
    }

    @Nullable
    public final Object get(final int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        FoundryFieldSchema fieldSchema = this.getSchema().get(ordinal);
        if (fieldSchema.getUserDefinedTypeClass().isPresent()) {
            return this.getUdt(ordinal);
        }
        return fieldSchema.getType().accept(new FoundryFieldType.Visitor<Object>(){

            @Override
            public Object visitArray() {
                return LatitudeRow.this.getArray(ordinal);
            }

            @Override
            public Object visitDecimal() {
                return LatitudeRow.this.getDecimal(ordinal);
            }

            @Override
            public Object visitMap() {
                return LatitudeRow.this.getMap(ordinal);
            }

            @Override
            public Object visitStruct() {
                return LatitudeRow.this.getStruct(ordinal);
            }

            @Override
            public Object visitLong() {
                return LatitudeRow.this.getLong(ordinal);
            }

            @Override
            public Object visitBinary() {
                return LatitudeRow.this.getBinary(ordinal);
            }

            @Override
            public Object visitBoolean() {
                return LatitudeRow.this.getBoolean(ordinal);
            }

            @Override
            public Object visitByte() {
                return LatitudeRow.this.getByte(ordinal);
            }

            @Override
            public Object visitDate() {
                return LatitudeRow.this.getDate(ordinal);
            }

            @Override
            public Object visitDouble() {
                return LatitudeRow.this.getDouble(ordinal);
            }

            @Override
            public Object visitFloat() {
                return Float.valueOf(LatitudeRow.this.getFloat(ordinal));
            }

            @Override
            public Object visitInteger() {
                return LatitudeRow.this.getInteger(ordinal);
            }

            @Override
            public Object visitShort() {
                return LatitudeRow.this.getShort(ordinal);
            }

            @Override
            public Object visitString() {
                return LatitudeRow.this.getString(ordinal);
            }

            @Override
            public Object visitTimestamp() {
                return LatitudeRow.this.getTimestamp(ordinal);
            }

            @Override
            public Object visitUnknown(String unknownValue) {
                throw ContourExceptions.serverUnknownUnionType(unknownValue, FoundryFieldType.class);
            }
        });
    }

    public final int numFields() {
        return this.schema.size();
    }

    public abstract boolean isNullAt(int var1);

    public abstract byte[] getBinary(int var1);

    public abstract boolean getBoolean(int var1);

    public abstract byte getByte(int var1);

    public abstract LocalDate getDate(int var1);

    public abstract BigDecimal getDecimal(int var1);

    public abstract double getDouble(int var1);

    public abstract float getFloat(int var1);

    public abstract int getInteger(int var1);

    public abstract long getLong(int var1);

    public abstract short getShort(int var1);

    public abstract String getString(int var1);

    public abstract Instant getTimestamp(int var1);

    public abstract List<Object> getArray(int var1);

    public abstract Map<Object, Object> getMap(int var1);

    public abstract LatitudeStruct getStruct(int var1);

    public abstract Object getUdt(int var1);

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37).append(this.getSchema());
        for (int ordinal = 0; ordinal < this.numFields(); ++ordinal) {
            builder.append(this.get(ordinal));
        }
        return builder.toHashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LatitudeRow)) {
            return false;
        }
        LatitudeRow other = (LatitudeRow)obj;
        if (this.numFields() != other.numFields()) {
            return false;
        }
        for (int ordinal = 0; ordinal < this.numFields(); ++ordinal) {
            if (this.isNullAt(ordinal) != other.isNullAt(ordinal)) {
                return false;
            }
            if (this.isNullAt(ordinal)) continue;
            Object obj1 = this.get(ordinal);
            Object obj2 = other.get(ordinal);
            if (!(obj1 instanceof byte[] ? !(obj2 instanceof byte[]) || !Arrays.equals((byte[])obj1, (byte[])obj2) : (obj1 instanceof Float && Float.isNaN(((Float)obj1).floatValue()) ? !(obj2 instanceof Float) || !Float.isNaN(((Float)obj2).floatValue()) : (obj1 instanceof Double && Double.isNaN((Double)obj1) ? !(obj2 instanceof Double) || !Double.isNaN((Double)obj2) : (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal ? ((BigDecimal)obj1).compareTo((BigDecimal)obj2) != 0 : !Objects.equals(obj1, obj2)))))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Object[] values = new Object[this.numFields()];
        for (int ordinal = 0; ordinal < this.numFields(); ++ordinal) {
            values[ordinal] = this.get(ordinal);
        }
        return MoreObjects.toStringHelper(this.getClass()).add("schema", this.getSchema()).add("values", values).toString();
    }
}

