/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Unsafe;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;
import shadow.palantir.driver.com.palantir.contour.ipc.ImmutableLatitudeRowStreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.StreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.TableLatitudeResultMetadata;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterable;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterator;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterators;
import shadow.palantir.driver.com.palantir.contour.ipc.util.OneShotIterable;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@Value.Immutable
public abstract class LatitudeRowStreamingTableLatitudeResult
extends StreamingTableLatitudeResult {
    @Override
    public final <T> T accept(StreamingTableLatitudeResult.Visitor<T> visitor) {
        return visitor.visitLatitudeRowStreamingTableLatitudeResult(this);
    }

    public static LatitudeRowStreamingTableLatitudeResult of(TableLatitudeResultMetadata metadata, Iterator<LatitudeRow> rowIterator) {
        return LatitudeRowStreamingTableLatitudeResult.of(metadata, CloseableIterators.of(rowIterator));
    }

    public static LatitudeRowStreamingTableLatitudeResult of(TableLatitudeResultMetadata metadata, CloseableIterator<LatitudeRow> rowIterator) {
        return LatitudeRowStreamingTableLatitudeResult.of(metadata, new OneShotIterable<LatitudeRow>(rowIterator));
    }

    public static LatitudeRowStreamingTableLatitudeResult of(TableLatitudeResultMetadata metadata, CloseableIterable<LatitudeRow> rowIterable) {
        ZonedDateTime computedTime = Instant.ofEpochMilli(metadata.getComputedTime().getMillis()).atZone(ZoneId.of(metadata.getComputedTime().getZone().getID(), ZoneId.SHORT_IDS));
        return ImmutableLatitudeRowStreamingTableLatitudeResult.builder().computedTime(computedTime).computedVersion(metadata.getComputedVersion()).warningMessage(metadata.getWarningMessage()).resultComputationMetadata(metadata.getResultComputationMetadata()).resultId(metadata.getResultId()).rowCount(metadata.getRowCount()).primaryKeyInformation(metadata.getPrimaryKeyInformation()).columns(metadata.getColumns()).columnTypes(metadata.getColumnTypes()).rowIterable(rowIterable).build();
    }
}

