/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.ObjectMappers;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;

public final class LatitudeStruct
extends LatitudeRow {
    private static final SafeLogger log = SafeLoggerFactory.get(LatitudeStruct.class);
    private final LatitudeRow row;

    private LatitudeStruct(LatitudeRow row) {
        super(row.getSchema());
        this.row = row;
    }

    public static LatitudeStruct of(LatitudeRow row) {
        Preconditions.checkArgument(row.getSchema().stream().map(FoundryFieldSchema::getName).allMatch(Optional::isPresent), "LatitudeStruct schema should include a name for all fields");
        return new LatitudeStruct(row);
    }

    @JsonValue
    public Map<String, Object> getValue() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int ordinal = 0; ordinal < this.numFields(); ++ordinal) {
            String name = this.row.getSchema().get(ordinal).getName().orElseThrow(SafeIllegalStateException::new);
            result.put(name, this.get(ordinal));
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return ObjectMappers.newClientObjectMapper().writeValueAsString(this.getValue());
        }
        catch (JsonProcessingException e) {
            log.info("Caught an exception parsing LatitudeStruct. Falling back to Map's toString method", e);
            return this.getValue().toString();
        }
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.row.isNullAt(ordinal);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return this.row.getBinary(ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return this.row.getBoolean(ordinal);
    }

    @Override
    public byte getByte(int ordinal) {
        return this.row.getByte(ordinal);
    }

    @Override
    public LocalDate getDate(int ordinal) {
        return this.row.getDate(ordinal);
    }

    @Override
    public BigDecimal getDecimal(int ordinal) {
        return this.row.getDecimal(ordinal);
    }

    @Override
    public double getDouble(int ordinal) {
        return this.row.getDouble(ordinal);
    }

    @Override
    public float getFloat(int ordinal) {
        return this.row.getFloat(ordinal);
    }

    @Override
    public int getInteger(int ordinal) {
        return this.row.getInteger(ordinal);
    }

    @Override
    public long getLong(int ordinal) {
        return this.row.getLong(ordinal);
    }

    @Override
    public short getShort(int ordinal) {
        return this.row.getShort(ordinal);
    }

    @Override
    public String getString(int ordinal) {
        return this.row.getString(ordinal);
    }

    @Override
    public Instant getTimestamp(int ordinal) {
        return this.row.getTimestamp(ordinal);
    }

    @Override
    public List<Object> getArray(int ordinal) {
        return this.row.getArray(ordinal);
    }

    @Override
    public Map<Object, Object> getMap(int ordinal) {
        return this.row.getMap(ordinal);
    }

    @Override
    public LatitudeStruct getStruct(int ordinal) {
        return this.row.getStruct(ordinal);
    }

    @Override
    public Object getUdt(int ordinal) {
        return this.row.getUdt(ordinal);
    }
}

