/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.concurrent.atomic.AtomicLong;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterator;

final class RowCountValidatingIterator
implements CloseableIterator<LatitudeRow> {
    private final CloseableIterator<LatitudeRow> delegate;
    private final long expectedRowCount;
    private final AtomicLong consumedRowCount = new AtomicLong(0L);

    RowCountValidatingIterator(CloseableIterator<LatitudeRow> delegate, long expectedRowCount) {
        this.delegate = delegate;
        this.expectedRowCount = expectedRowCount;
    }

    @Override
    public boolean hasNext() {
        boolean delegateHasNext;
        boolean shouldHaveNext = this.consumedRowCount.get() < this.expectedRowCount;
        if (shouldHaveNext == (delegateHasNext = this.delegate.hasNext())) {
            return shouldHaveNext;
        }
        if (shouldHaveNext) {
            throw new SafeIllegalStateException("The row iterator doesn't have any more rows, even though we haven't consumed all expected rows yet. A potential cause for this is that the underlying iterator has been (partially) consumed before.", SafeArg.of("expectedRowCount", this.expectedRowCount), SafeArg.of("consumedRowCount", this.consumedRowCount.get()));
        }
        throw new SafeIllegalStateException("We have processed all expected rows, but the underlying iterator still contains unconsumed rows. This is likely due to a programmer error", SafeArg.of("expectedRowCount", this.expectedRowCount), SafeArg.of("consumedRowCount", this.consumedRowCount.get()));
    }

    @Override
    public LatitudeRow next() {
        this.consumedRowCount.incrementAndGet();
        return (LatitudeRow)this.delegate.next();
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }
}

