/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonFactory;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.core.type.TypeReference;
import shadow.palantir.driver.com.google.common.collect.Iterators;
import shadow.palantir.driver.com.palantir.contour.ipc.ContourIpcJackson;
import shadow.palantir.driver.com.palantir.contour.ipc.GenericLatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeResultDeserializer;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeResultWrapper;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRowStreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.TableLatitudeResultMetadata;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterators;

enum RowIteratingJsonStreamTableLatitudeResultDeserializer implements LatitudeResultDeserializer
{
    INSTANCE;


    @Override
    public LatitudeResultWrapper deserialize(InputStream stream) throws IOException {
        JsonFactory jsonFactory = ContourIpcJackson.OBJECT_MAPPER.getFactory();
        JsonParser jsonParser = jsonFactory.createParser(stream);
        TableLatitudeResultMetadata tableLatitudeResultMetadata = this.deserializeTableLatitudeResultMetadataInternal(jsonParser);
        jsonParser.nextValue();
        Preconditions.checkState(Objects.equals(jsonParser.getCurrentName(), "rows"));
        if (!Objects.equals((Object)jsonParser.currentToken(), (Object)JsonToken.START_ARRAY)) {
            throw new SafeIoException("Unexpected token for start of rows value", SafeArg.of("expected", JsonToken.START_ARRAY), UnsafeArg.of("actual", jsonParser.currentToken()));
        }
        jsonParser.clearCurrentToken();
        Iterator<List<Object>> rowIterator = jsonParser.readValuesAs(new TypeReference<List<Object>>(){});
        return LatitudeResultWrapper.of(LatitudeRowStreamingTableLatitudeResult.of(tableLatitudeResultMetadata, CloseableIterators.of(Iterators.transform(rowIterator, row -> GenericLatitudeRow.of(row, tableLatitudeResultMetadata.getColumnTypes())), () -> {
            JsonToken token = jsonParser.nextToken();
            if (token != JsonToken.END_OBJECT) {
                throw new SafeIoException("Unexpected end of ROW_ITERATING_JSON stream", SafeArg.of("expected", JsonToken.END_OBJECT), UnsafeArg.of("actual", token));
            }
            jsonParser.close();
            stream.close();
        })));
    }

    public TableLatitudeResultMetadata deserializeTableLatitudeResultMetadata(InputStream stream) throws IOException {
        JsonFactory jsonFactory = ContourIpcJackson.OBJECT_MAPPER.getFactory();
        JsonParser jsonParser = jsonFactory.createParser(stream);
        return this.deserializeTableLatitudeResultMetadataInternal(jsonParser);
    }

    private TableLatitudeResultMetadata deserializeTableLatitudeResultMetadataInternal(JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() != JsonToken.START_OBJECT) {
            throw new SafeIoException("Expected data to start with an Object", new Arg[0]);
        }
        jsonParser.nextValue();
        Preconditions.checkState(Objects.equals(jsonParser.getCurrentName(), "metadata"));
        return jsonParser.readValueAs(TableLatitudeResultMetadata.class);
    }
}

