/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import latitude.api.SerializationProtocol;

public final class SerializationUtils {
    public static final char ROW_ITERATING_JSON_STREAM = 'S';
    public static final char ARROW_STREAM = 'A';

    private SerializationUtils() {
    }

    public static <T> T getFormatAndProcess(InputStream stream, ProtocolAwareStreamProcessor<T> processor) throws IOException {
        char first = (char)stream.read();
        if (first == 'S') {
            return processor.accept(stream, SerializationProtocol.ROW_ITERATING_JSON);
        }
        if (first == 'A') {
            return processor.accept(stream, SerializationProtocol.ARROW);
        }
        return processor.accept(new SequenceInputStream(new ByteArrayInputStream(new byte[]{(byte)first}), stream), SerializationProtocol.JSON);
    }

    public static byte[] serialize(Serializer serializer) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            serializer.accept(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toByteArray();
    }

    @FunctionalInterface
    public static interface ProtocolAwareStreamProcessor<T> {
        public T accept(InputStream var1, SerializationProtocol var2) throws IOException;
    }

    @FunctionalInterface
    public static interface Serializer {
        public void accept(OutputStream var1) throws IOException;
    }
}

