/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Unsafe;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import latitude.api.results.LatitudeResult;
import latitude.api.results.PrimaryKeyInformation;
import latitude.api.results.TableLatitudeResultV2;
import latitude.api.results.metadata.ResultComputationMetadata;
import latitude.api.results.metadata.ResultId;
import shadow.palantir.driver.com.google.common.base.Throwables;
import shadow.palantir.driver.com.palantir.contour.ipc.ArrowStreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRowStreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.contour.ipc.RowCountValidatingIterator;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterable;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterator;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.org.immutables.value.Value;
import shadow.palantir.driver.org.joda.time.DateTime;
import shadow.palantir.driver.org.joda.time.DateTimeZone;

public abstract class StreamingTableLatitudeResult {
    public abstract ZonedDateTime getComputedTime();

    public abstract Optional<String> getComputedVersion();

    public abstract Optional<String> getWarningMessage();

    public abstract Optional<ResultComputationMetadata> getResultComputationMetadata();

    public abstract Optional<ResultId> getResultId();

    public abstract Optional<Integer> getRowCount();

    public abstract List<String> getColumns();

    public abstract List<FoundryFieldSchema> getColumnTypes();

    public abstract Optional<PrimaryKeyInformation> getPrimaryKeyInformation();

    protected abstract CloseableIterable<LatitudeRow> rowIterable();

    public final CloseableIterator<LatitudeRow> rowIterator() {
        return this.getRowCount().map(rowCount -> new RowCountValidatingIterator(this.rowIterable().iterator(), rowCount.intValue())).orElseGet(() -> this.rowIterable().iterator());
    }

    @Value.Lazy
    public DateTime getComputedTimeJoda() {
        return new DateTime(this.getComputedTime().toInstant().toEpochMilli(), DateTimeZone.forTimeZone(TimeZone.getTimeZone(this.getComputedTime().getZone())));
    }

    @Unsafe
    @Value.Lazy
    public LatitudeResult asLatitudeResult() {
        ArrayList<List> columns = new ArrayList<List>(this.getColumns().size());
        for (int i = 0; i < this.getColumns().size(); ++i) {
            columns.add(this.getRowCount().map(ArrayList::new).orElseGet(ArrayList::new));
        }
        int rowCount = 0;
        try (CloseableIterator<LatitudeRow> iterator = this.rowIterator();){
            while (iterator.hasNext()) {
                LatitudeRow row = (LatitudeRow)iterator.next();
                for (int i = 0; i < this.getColumns().size(); ++i) {
                    ((List)columns.get(i)).add(row.get(i));
                }
                ++rowCount;
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
        return TableLatitudeResultV2.builder().columns(this.getColumns()).columnTypes(this.getColumnTypes()).computedTime(this.getComputedTimeJoda()).computedVersion(this.getComputedVersion()).primaryKeyInformation(this.getPrimaryKeyInformation()).resultId(this.getResultId()).rowCount(rowCount).results(columns).resultComputationMetadata(this.getResultComputationMetadata()).warningMessage(this.getWarningMessage()).build();
    }

    public abstract StreamingTableLatitudeResult withResultComputationMetadata(Optional<? extends ResultComputationMetadata> var1);

    public abstract <T> T accept(Visitor<T> var1);

    static interface Visitor<T> {
        public T visitArrowStreamingTableLatitudeResult(ArrowStreamingTableLatitudeResult var1);

        public T visitLatitudeRowStreamingTableLatitudeResult(LatitudeRowStreamingTableLatitudeResult var1);
    }
}

