/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc;

import com.palantir.logsafe.Unsafe;
import java.util.List;
import java.util.Optional;
import latitude.api.results.PrimaryKeyInformation;
import latitude.api.results.TableLatitudeResult;
import latitude.api.results.metadata.ResultId;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.contour.ipc.ImmutableTableLatitudeResultMetadata;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeResultMetadata;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeResultMetadataVisitor;
import shadow.palantir.driver.com.palantir.contour.ipc.StreamingTableLatitudeResult;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonDeserialize(as=ImmutableTableLatitudeResultMetadata.class)
@Value.Immutable
public interface TableLatitudeResultMetadata
extends LatitudeResultMetadata {
    public Optional<String> getComputedVersion();

    public Optional<String> getWarningMessage();

    public Optional<ResultId> getResultId();

    public Optional<Integer> getRowCount();

    public List<String> getColumns();

    public List<FoundryFieldSchema> getColumnTypes();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="primaryKeyInformation")
    public Optional<PrimaryKeyInformation> getPrimaryKeyInformation();

    @Override
    default public <T, V extends LatitudeResultMetadataVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public static TableLatitudeResultMetadata from(TableLatitudeResult tableLatitudeResult) {
        return TableLatitudeResultMetadata.builder().computedTime(tableLatitudeResult.getComputedTime()).computedVersion(tableLatitudeResult.getComputedVersion()).warningMessage(tableLatitudeResult.getWarningMessage()).resultComputationMetadata(tableLatitudeResult.getResultComputationMetadata()).resultId(tableLatitudeResult.getResultId()).rowCount(tableLatitudeResult.getRowCount()).columns(tableLatitudeResult.getColumns()).columnTypes(tableLatitudeResult.getColumnTypes()).primaryKeyInformation(tableLatitudeResult.getPrimaryKeyInformation()).build();
    }

    public static TableLatitudeResultMetadata from(StreamingTableLatitudeResult streamingTableLatitudeResult) {
        return TableLatitudeResultMetadata.builder().computedTime(streamingTableLatitudeResult.getComputedTimeJoda()).computedVersion(streamingTableLatitudeResult.getComputedVersion()).warningMessage(streamingTableLatitudeResult.getWarningMessage()).resultComputationMetadata(streamingTableLatitudeResult.getResultComputationMetadata()).resultId(streamingTableLatitudeResult.getResultId()).rowCount(streamingTableLatitudeResult.getRowCount()).columns(streamingTableLatitudeResult.getColumns()).columnTypes(streamingTableLatitudeResult.getColumnTypes()).primaryKeyInformation(streamingTableLatitudeResult.getPrimaryKeyInformation()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableTableLatitudeResultMetadata.Builder {
    }
}

