/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow;

import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ArrowLatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;

final class ArrowLatitudePartition
implements Closeable {
    private final ArrowVectorAccessor[] columns;
    private int rowCount;

    ArrowLatitudePartition(ArrowVectorAccessor[] columns) {
        this.columns = columns;
    }

    @Override
    public void close() {
        for (ArrowVectorAccessor column : this.columns) {
            column.close();
        }
    }

    public void setRowCount(int newRowCount) {
        this.rowCount = newRowCount;
    }

    Iterator<LatitudeRow> rowIterator() {
        final int maxRows = this.rowCount;
        return new Iterator<LatitudeRow>(){
            private int rowId = 0;

            @Override
            public boolean hasNext() {
                return this.rowId < maxRows;
            }

            @Override
            public LatitudeRow next() {
                if (this.rowId >= maxRows) {
                    throw new NoSuchElementException();
                }
                return new ArrowLatitudeRow(ArrowLatitudePartition.this.columns, this.rowId++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

