/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIoException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.util.Iterator;
import java.util.NoSuchElementException;
import shadow.palantir.driver.com.google.common.collect.Iterators;
import shadow.palantir.driver.com.google.common.collect.UnmodifiableIterator;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.SerializationUtils;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ArrowLatitudePartition;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ContourArrowUtils;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterator;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.arrow.memory.BufferAllocator;
import shadow.palantir.driver.org.apache.arrow.vector.VectorSchemaRoot;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.ArrowStreamReader;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.ArrowStreamWriter;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.WriteChannel;
import shadow.palantir.driver.org.apache.arrow.vector.ipc.message.IpcOption;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Schema;

public final class ArrowRowIterator
implements CloseableIterator<LatitudeRow> {
    private final BufferAllocator allocator;
    private final ArrowStreamReader reader;
    private final VectorSchemaRoot root;
    private final ArrowLatitudePartition batch;
    private final DataInputStream stream;
    @Nullable
    private Iterator<LatitudeRow> delegate;
    private boolean eof = false;

    public static ArrowRowIterator create(Schema arrowSchema, Iterator<byte[]> arrowBatches) throws IOException {
        BufferAllocator allocator = ContourArrowUtils.ROOT_ALLOCATOR.newChildAllocator("ArrowRowIterator", 0L, Long.MAX_VALUE);
        UnmodifiableIterator<byte[]> schema = Iterators.singletonIterator(SerializationUtils.serialize(out -> {
            VectorSchemaRoot rootForSchema = VectorSchemaRoot.create(arrowSchema, allocator);
            ArrowStreamWriter writer = new ArrowStreamWriter(rootForSchema, null, out);
            writer.start();
        }));
        UnmodifiableIterator<byte[]> eos = Iterators.singletonIterator(SerializationUtils.serialize(out -> {
            ArrowStreamWriter.writeEndOfStream(new WriteChannel(Channels.newChannel(out)), new IpcOption());
            ContourArrowUtils.writeEos(out);
        }));
        SequenceInputStream stream = new SequenceInputStream(Iterators.asEnumeration(Iterators.transform(Iterators.concat(schema, arrowBatches, eos), ByteArrayInputStream::new)));
        ArrowStreamReader reader = new ArrowStreamReader(stream, allocator);
        return new ArrowRowIterator(reader, allocator, new DataInputStream(stream));
    }

    public ArrowRowIterator(ArrowStreamReader reader, BufferAllocator allocator, DataInputStream stream) throws IOException {
        this.allocator = allocator;
        this.reader = reader;
        this.root = reader.getVectorSchemaRoot();
        this.batch = new ArrowLatitudePartition((ArrowVectorAccessor[])this.root.getFieldVectors().stream().map(ArrowVectorAccessor::of).toArray(ArrowVectorAccessor[]::new));
        this.stream = stream;
    }

    @Override
    public void close() throws IOException {
        this.reader.close(true);
        this.batch.close();
        this.allocator.close();
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        try {
            return this.hasNextUnsafe();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public LatitudeRow next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.delegate.next();
    }

    private boolean hasNextUnsafe() throws IOException {
        boolean hasNext;
        if (this.delegate != null && this.delegate.hasNext()) {
            return true;
        }
        boolean bl = hasNext = this.loadNextBatch() && this.delegate != null && this.delegate.hasNext();
        if (!hasNext) {
            this.close();
            return false;
        }
        return true;
    }

    private boolean loadNextBatch() throws IOException {
        if (this.reader.loadNextBatch()) {
            this.batch.setRowCount(this.root.getRowCount());
            this.delegate = this.batch.rowIterator();
            return true;
        }
        if (69 != this.stream.readByte()) {
            throw new SafeIoException("Unexpected end of ARROW stream", new Arg[0]);
        }
        this.eof = true;
        return false;
    }
}

