/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import latitude.api.jackson.ContourJackson;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.Functions;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.collect.Iterables;
import shadow.palantir.driver.com.google.common.collect.Maps;
import shadow.palantir.driver.com.palantir.contour.ipc.TableLatitudeResultMetadata;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;
import shadow.palantir.driver.one.util.streamex.StreamEx;
import shadow.palantir.driver.org.apache.arrow.vector.types.DateUnit;
import shadow.palantir.driver.org.apache.arrow.vector.types.FloatingPointPrecision;
import shadow.palantir.driver.org.apache.arrow.vector.types.TimeUnit;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.ArrowType;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Field;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.FieldType;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Schema;

public final class ArrowSchemaUtils {
    private static final ObjectMapper MAPPER = ContourJackson.getNewStandaloneObjectMapper();
    private static final String METADATA_KEY = "metadata";

    public static TableLatitudeResultMetadata toTableLatitudeResultMetadata(Schema schema) {
        try {
            return MAPPER.readValue(schema.getCustomMetadata().get(METADATA_KEY), TableLatitudeResultMetadata.class);
        }
        catch (JsonProcessingException e) {
            throw new SafeRuntimeException("Could not deserialize TableLatitudeResultMetadata", (Throwable)e, new Arg[0]);
        }
    }

    public static FoundryFieldSchema toFoundryField(Field arrowField) {
        FoundryFieldSchema.Builder builder = FoundryFieldSchema.builder().customMetadata(Maps.transformValues(arrowField.getMetadata(), Functions.identity())).nullable(arrowField.isNullable());
        if (arrowField.getType() instanceof ArrowType.List) {
            FoundryFieldSchema arraySubtype = ArrowSchemaUtils.toFoundryField(Iterables.getOnlyElement(arrowField.getChildren()));
            return builder.type(FoundryFieldType.ARRAY).arraySubtype(arraySubtype).build();
        }
        if (arrowField.getType() instanceof ArrowType.Binary) {
            return builder.type(FoundryFieldType.BINARY).build();
        }
        if (arrowField.getType() instanceof ArrowType.Bool) {
            return builder.type(FoundryFieldType.BOOLEAN).build();
        }
        if (arrowField.getType() instanceof ArrowType.Date) {
            return builder.type(FoundryFieldType.DATE).build();
        }
        if (arrowField.getType() instanceof ArrowType.Decimal) {
            int precision = ((ArrowType.Decimal)arrowField.getType()).getPrecision();
            int scale = ((ArrowType.Decimal)arrowField.getType()).getScale();
            return builder.type(FoundryFieldType.DECIMAL).precision(precision).scale(scale).build();
        }
        if (arrowField.getType() instanceof ArrowType.FloatingPoint) {
            ArrowType.FloatingPoint floatingPoint = (ArrowType.FloatingPoint)arrowField.getType();
            if (floatingPoint.getPrecision().equals((Object)FloatingPointPrecision.DOUBLE)) {
                return builder.type(FoundryFieldType.DOUBLE).build();
            }
            if (floatingPoint.getPrecision().equals((Object)FloatingPointPrecision.SINGLE)) {
                return builder.type(FoundryFieldType.FLOAT).build();
            }
            throw new SafeIllegalArgumentException("Unsupported ArrowType type", SafeArg.of("arrowType", arrowField.getType()));
        }
        if (arrowField.getType() instanceof ArrowType.Int) {
            ArrowType.Int intType = (ArrowType.Int)arrowField.getType();
            if (!intType.getIsSigned()) {
                throw new SafeIllegalArgumentException("Unsupported ArrowType type", SafeArg.of("arrowType", arrowField.getType()));
            }
            if (intType.getBitWidth() == 8) {
                return builder.type(FoundryFieldType.BYTE).build();
            }
            if (intType.getBitWidth() == 16) {
                return builder.type(FoundryFieldType.SHORT).build();
            }
            if (intType.getBitWidth() == 32) {
                return builder.type(FoundryFieldType.INTEGER).build();
            }
            if (intType.getBitWidth() == 64) {
                return builder.type(FoundryFieldType.LONG).build();
            }
            throw new SafeIllegalArgumentException("Unsupported ArrowType type", SafeArg.of("arrowType", arrowField.getType()));
        }
        if (arrowField.getType() instanceof ArrowType.Utf8) {
            return builder.type(FoundryFieldType.STRING).build();
        }
        if (arrowField.getType() instanceof ArrowType.Timestamp) {
            return builder.type(FoundryFieldType.TIMESTAMP).build();
        }
        if (arrowField.getType() instanceof ArrowType.Map) {
            Field elementField = Iterables.getOnlyElement(arrowField.getChildren());
            FoundryFieldSchema keyType = ArrowSchemaUtils.toFoundryField(elementField.getChildren().get(0));
            FoundryFieldSchema valueType = ArrowSchemaUtils.toFoundryField(elementField.getChildren().get(1));
            return builder.type(FoundryFieldType.MAP).mapKeyType(keyType).mapValueType(valueType).build();
        }
        if (arrowField.getType() instanceof ArrowType.Struct) {
            List<FoundryFieldSchema> nestedFieldSchemas = arrowField.getChildren().stream().map(field -> FoundryFieldSchema.builder().from(ArrowSchemaUtils.toFoundryField(field)).name(field.getName()).nullable(field.isNullable()).build()).collect(Collectors.toList());
            return builder.type(FoundryFieldType.STRUCT).subSchemas(nestedFieldSchemas).build();
        }
        throw new SafeIllegalArgumentException("Unsupported ArrowType type", SafeArg.of("arrowType", arrowField.getType()));
    }

    public static Schema toArrowSchema(TableLatitudeResultMetadata metadata) {
        ImmutableMap<String, String> customMetadata;
        List<Field> fields = StreamEx.zip(metadata.getColumns(), metadata.getColumnTypes(), ArrowSchemaUtils::toArrowField).collect(Collectors.toList());
        try {
            customMetadata = ImmutableMap.of(METADATA_KEY, MAPPER.writeValueAsString(metadata));
        }
        catch (JsonProcessingException e) {
            throw new SafeRuntimeException("Could not serialize TableLatitudeResultMetadata", (Throwable)e, new Arg[0]);
        }
        return new Schema(fields, customMetadata);
    }

    private static Field field(String name, FoundryFieldSchema foundryField, ArrowType arrowType) {
        return ArrowSchemaUtils.field(name, foundryField, arrowType, Collections.emptyList());
    }

    private static Field field(String name, FoundryFieldSchema foundryField, ArrowType arrowType, List<Field> children) {
        return new Field(name, new FieldType(foundryField.getNullable().orElse(true), arrowType, null, null), children);
    }

    @VisibleForTesting
    static Field toArrowField(String name, FoundryFieldSchema foundryField) {
        FoundryFieldType fieldType = foundryField.getType();
        if (fieldType.equals(FoundryFieldType.BINARY)) {
            return ArrowSchemaUtils.field(name, foundryField, ArrowType.Binary.INSTANCE);
        }
        if (fieldType.equals(FoundryFieldType.BOOLEAN)) {
            return ArrowSchemaUtils.field(name, foundryField, ArrowType.Bool.INSTANCE);
        }
        if (fieldType.equals(FoundryFieldType.BYTE)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Int(8, true));
        }
        if (fieldType.equals(FoundryFieldType.DATE)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Date(DateUnit.DAY));
        }
        if (fieldType.equals(FoundryFieldType.DECIMAL)) {
            int precision = foundryField.getPrecision().getAsInt();
            int scale = foundryField.getScale().getAsInt();
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Decimal(precision, scale));
        }
        if (fieldType.equals(FoundryFieldType.DOUBLE)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
        }
        if (fieldType.equals(FoundryFieldType.FLOAT)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
        }
        if (fieldType.equals(FoundryFieldType.INTEGER)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Int(32, true));
        }
        if (fieldType.equals(FoundryFieldType.LONG)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Int(64, true));
        }
        if (fieldType.equals(FoundryFieldType.SHORT)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Int(16, true));
        }
        if (fieldType.equals(FoundryFieldType.STRING)) {
            return ArrowSchemaUtils.field(name, foundryField, ArrowType.Utf8.INSTANCE);
        }
        if (fieldType.equals(FoundryFieldType.TIMESTAMP)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC"));
        }
        if (fieldType.equals(FoundryFieldType.ARRAY)) {
            Field elementField = ArrowSchemaUtils.toArrowField("element", foundryField.getArraySubtype().get());
            return ArrowSchemaUtils.field(name, foundryField, ArrowType.List.INSTANCE, ImmutableList.of(elementField));
        }
        if (fieldType.equals(FoundryFieldType.MAP)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Map(false), ImmutableList.of(ArrowSchemaUtils.toArrowField("entries", FoundryFieldSchema.builder().type(FoundryFieldType.STRUCT).subSchemas(ImmutableList.of(FoundryFieldSchema.builder().from(foundryField.getMapKeyType().get()).name("key").nullable(false).build(), FoundryFieldSchema.builder().from(foundryField.getMapValueType().get()).name("value").nullable(true).build())).nullable(false).build())));
        }
        if (fieldType.equals(FoundryFieldType.STRUCT)) {
            return ArrowSchemaUtils.field(name, foundryField, new ArrowType.Struct(), foundryField.getSubSchemas().get().stream().map(field -> ArrowSchemaUtils.toArrowField(field.getName().get(), field)).collect(Collectors.toList()));
        }
        throw new SafeIllegalArgumentException("Unsupported FoundryFieldSchema type", SafeArg.of("fieldType", fieldType));
    }

    private ArrowSchemaUtils() {
    }
}

