/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.palantir.contour.ipc.GenericLatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowLatitudeColumnarArray;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.org.apache.arrow.memory.ArrowBuf;
import shadow.palantir.driver.org.apache.arrow.vector.complex.ListVector;

public final class ArrayArrowVectorAccessor
extends ArrowVectorAccessor {
    private final ListVector accessor;
    private final ArrowVectorAccessor elements;

    public ArrayArrowVectorAccessor(ListVector vector, ArrowVectorAccessor elements) {
        super(vector);
        this.accessor = vector;
        this.elements = elements;
    }

    @Override
    public List<Object> getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        ArrowBuf offsets = this.accessor.getOffsetBuffer();
        int index = rowId * 4;
        int start = offsets.getInt(index);
        int end = offsets.getInt(index + 4);
        ArrowLatitudeColumnarArray row = new ArrowLatitudeColumnarArray(this.elements, start, end - start);
        return Arrays.asList(row.asArray());
    }

    @Override
    protected void setNull() {
    }

    @Override
    protected void setValue(LatitudeRow row, int ordinal) {
        List<Object> array = row.getArray(ordinal);
        List<FoundryFieldSchema> schema = Collections.nCopies(array.size(), this.elements.getType());
        this.accessor.startNewValue(this.getCount());
        for (int index = 0; index < array.size(); ++index) {
            this.elements.write(GenericLatitudeRow.of(array, schema), index);
        }
        this.accessor.endValue(this.getCount(), array.size());
    }

    @Override
    public void finish() {
        super.finish();
        this.elements.finish();
    }

    @Override
    public void reset() {
        super.reset();
        this.elements.reset();
    }
}

