/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;

final class ArrowLatitudeColumnarArray {
    private final ArrowVectorAccessor data;
    private final int offset;
    private final int length;

    ArrowLatitudeColumnarArray(ArrowVectorAccessor data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    Object[] asArray() {
        FoundryFieldSchema type = this.data.getType();
        Object[] list = new Object[this.length];
        try {
            for (int i = 0; i < this.length; ++i) {
                if (this.data.isNullAt(this.offset + i)) continue;
                list[i] = this.get(i, type);
            }
            return list;
        }
        catch (Exception e) {
            throw new SafeRuntimeException("Could not get the array", (Throwable)e, new Arg[0]);
        }
    }

    private Object get(final int ordinal, FoundryFieldSchema fieldSchema) {
        return fieldSchema.getType().accept(new FoundryFieldType.Visitor<Object>(){

            @Override
            public Object visitArray() {
                return ArrowLatitudeColumnarArray.this.data.getArray(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitDecimal() {
                return ArrowLatitudeColumnarArray.this.data.getDecimal(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitMap() {
                return ArrowLatitudeColumnarArray.this.data.getMap(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitStruct() {
                return ArrowLatitudeColumnarArray.this.data.getStruct(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitLong() {
                return ArrowLatitudeColumnarArray.this.data.getLong(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitBinary() {
                return ArrowLatitudeColumnarArray.this.data.getBinary(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitBoolean() {
                return ArrowLatitudeColumnarArray.this.data.getBoolean(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitByte() {
                return ArrowLatitudeColumnarArray.this.data.getByte(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitDate() {
                return ArrowLatitudeColumnarArray.this.data.getDate(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitDouble() {
                return ArrowLatitudeColumnarArray.this.data.getDouble(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitFloat() {
                return Float.valueOf(ArrowLatitudeColumnarArray.this.data.getFloat(ArrowLatitudeColumnarArray.this.offset + ordinal));
            }

            @Override
            public Object visitInteger() {
                return ArrowLatitudeColumnarArray.this.data.getInteger(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitShort() {
                return ArrowLatitudeColumnarArray.this.data.getShort(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitString() {
                return ArrowLatitudeColumnarArray.this.data.getString(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitTimestamp() {
                return ArrowLatitudeColumnarArray.this.data.getTimestamp(ArrowLatitudeColumnarArray.this.offset + ordinal);
            }

            @Override
            public Object visitUnknown(String unknownValue) {
                throw ContourExceptions.serverUnknownUnionType(unknownValue, FoundryFieldType.class);
            }
        });
    }
}

