/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeStruct;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ArrowSchemaUtils;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrayArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.BinaryArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.BooleanArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ByteArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.DateArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.DecimalArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.DoubleArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.FloatArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.IntegerArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.LongArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.MapArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ShortArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.StringArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.StructArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.TimestampArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.org.apache.arrow.vector.BigIntVector;
import shadow.palantir.driver.org.apache.arrow.vector.BitVector;
import shadow.palantir.driver.org.apache.arrow.vector.DateDayVector;
import shadow.palantir.driver.org.apache.arrow.vector.DecimalVector;
import shadow.palantir.driver.org.apache.arrow.vector.Float4Vector;
import shadow.palantir.driver.org.apache.arrow.vector.Float8Vector;
import shadow.palantir.driver.org.apache.arrow.vector.IntVector;
import shadow.palantir.driver.org.apache.arrow.vector.SmallIntVector;
import shadow.palantir.driver.org.apache.arrow.vector.TimeStampMicroTZVector;
import shadow.palantir.driver.org.apache.arrow.vector.TinyIntVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.VarBinaryVector;
import shadow.palantir.driver.org.apache.arrow.vector.VarCharVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.ListVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.MapVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.StructVector;

public abstract class ArrowVectorAccessor {
    private final ValueVector vector;
    private final FoundryFieldSchema type;
    private int count = 0;

    ArrowVectorAccessor(ValueVector vector) {
        this.vector = vector;
        this.type = ArrowSchemaUtils.toFoundryField(vector.getField());
    }

    public static ArrowVectorAccessor of(ValueVector vector) {
        if (vector instanceof BitVector) {
            return new BooleanArrowVectorAccessor((BitVector)vector);
        }
        if (vector instanceof TinyIntVector) {
            return new ByteArrowVectorAccessor((TinyIntVector)vector);
        }
        if (vector instanceof SmallIntVector) {
            return new ShortArrowVectorAccessor((SmallIntVector)vector);
        }
        if (vector instanceof IntVector) {
            return new IntegerArrowVectorAccessor((IntVector)vector);
        }
        if (vector instanceof BigIntVector) {
            return new LongArrowVectorAccessor((BigIntVector)vector);
        }
        if (vector instanceof Float4Vector) {
            return new FloatArrowVectorAccessor((Float4Vector)vector);
        }
        if (vector instanceof Float8Vector) {
            return new DoubleArrowVectorAccessor((Float8Vector)vector);
        }
        if (vector instanceof DecimalVector) {
            return new DecimalArrowVectorAccessor((DecimalVector)vector);
        }
        if (vector instanceof VarCharVector) {
            return new StringArrowVectorAccessor((VarCharVector)vector);
        }
        if (vector instanceof VarBinaryVector) {
            return new BinaryArrowVectorAccessor((VarBinaryVector)vector);
        }
        if (vector instanceof DateDayVector) {
            return new DateArrowVectorAccessor((DateDayVector)vector);
        }
        if (vector instanceof TimeStampMicroTZVector) {
            return new TimestampArrowVectorAccessor((TimeStampMicroTZVector)vector);
        }
        if (vector instanceof MapVector) {
            MapVector mapVector = (MapVector)vector;
            StructVector structVector = (StructVector)mapVector.getDataVector();
            ArrowVectorAccessor keyAccessor = ArrowVectorAccessor.of(structVector.getChild("key"));
            ArrowVectorAccessor valueAccessor = ArrowVectorAccessor.of(structVector.getChild("value"));
            return new MapArrowVectorAccessor(mapVector, structVector, keyAccessor, valueAccessor);
        }
        if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            return new ArrayArrowVectorAccessor(listVector, ArrowVectorAccessor.of(listVector.getDataVector()));
        }
        if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            ArrowVectorAccessor[] children = (ArrowVectorAccessor[])IntStream.range(0, structVector.size()).mapToObj(ordinal -> ArrowVectorAccessor.of(structVector.getChildByOrdinal(ordinal))).toArray(ArrowVectorAccessor[]::new);
            return new StructArrowVectorAccessor(structVector, children);
        }
        throw new UnsupportedOperationException();
    }

    public final FoundryFieldSchema getType() {
        return this.type;
    }

    public final int getCount() {
        return this.count;
    }

    public final void incrementCount() {
        ++this.count;
    }

    public final void close() {
        this.vector.close();
    }

    public final void write(LatitudeRow row, int ordinal) {
        if (row.isNullAt(ordinal)) {
            this.setNull();
        } else {
            this.setValue(row, ordinal);
        }
        ++this.count;
    }

    public final boolean isNullAt(int rowId) {
        return this.vector.isNull(rowId);
    }

    public void finish() {
        this.vector.setValueCount(this.count);
    }

    public void reset() {
        this.vector.reset();
        this.count = 0;
    }

    public byte[] getBinary(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public LocalDate getDate(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getDecimal(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public int getInteger(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public long getLong(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public short getShort(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public String getString(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public Instant getTimestamp(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getArray(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public Map<Object, Object> getMap(int _rowId) {
        throw new UnsupportedOperationException();
    }

    public LatitudeStruct getStruct(int _rowId) {
        throw new UnsupportedOperationException();
    }

    protected abstract void setNull();

    protected abstract void setValue(LatitudeRow var1, int var2);
}

