/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import java.time.LocalDate;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.org.apache.arrow.vector.DateDayVector;

public final class DateArrowVectorAccessor
extends ArrowVectorAccessor {
    private final DateDayVector accessor;

    public DateArrowVectorAccessor(DateDayVector vector) {
        super(vector);
        this.accessor = vector;
    }

    @Override
    public LocalDate getDate(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return LocalDate.ofEpochDay(this.accessor.get(rowId));
    }

    @Override
    public int getInteger(int rowId) {
        return this.accessor.get(rowId);
    }

    @Override
    protected void setNull() {
        this.accessor.setNull(this.getCount());
    }

    @Override
    protected void setValue(LatitudeRow row, int ordinal) {
        this.accessor.setSafe(this.getCount(), (int)row.getDate(ordinal).toEpochDay());
    }
}

