/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import shadow.palantir.driver.com.google.common.collect.Maps;
import shadow.palantir.driver.com.palantir.contour.ipc.GenericLatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowLatitudeColumnarArray;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.org.apache.arrow.vector.complex.MapVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.StructVector;

public final class MapArrowVectorAccessor
extends ArrowVectorAccessor {
    private final MapVector accessor;
    private final StructVector structVector;
    private final ArrowVectorAccessor keysAccessor;
    private final ArrowVectorAccessor valuesAccessor;

    public MapArrowVectorAccessor(MapVector vector, StructVector structVector, ArrowVectorAccessor keysAccessor, ArrowVectorAccessor valuesAccessor) {
        super(vector);
        this.accessor = vector;
        this.structVector = structVector;
        this.keysAccessor = keysAccessor;
        this.valuesAccessor = valuesAccessor;
    }

    @Override
    public Map<Object, Object> getMap(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        int offset = this.accessor.getOffsetBuffer().getInt(rowId * 4);
        int length = this.accessor.getInnerValueCountAt(rowId);
        Object[] keys = new ArrowLatitudeColumnarArray(this.keysAccessor, offset, length).asArray();
        Object[] values = new ArrowLatitudeColumnarArray(this.valuesAccessor, offset, length).asArray();
        HashMap<Object, Object> map = Maps.newHashMapWithExpectedSize(length);
        for (int index = 0; index < length; ++index) {
            map.put(keys[index], values[index]);
        }
        return map;
    }

    @Override
    protected void setNull() {
    }

    @Override
    protected void setValue(LatitudeRow row, int ordinal) {
        Map<Object, Object> map = row.getMap(ordinal);
        this.accessor.startNewValue(this.getCount());
        ArrayList<Object> keys = new ArrayList<Object>(map.keySet());
        List<Object> values = keys.stream().map(map::get).collect(Collectors.toList());
        LatitudeRow keysRow = MapArrowVectorAccessor.valuesAsRow(keys, this.keysAccessor.getType());
        LatitudeRow valuesRow = MapArrowVectorAccessor.valuesAsRow(values, this.valuesAccessor.getType());
        for (int index = 0; index < map.size(); ++index) {
            this.structVector.setIndexDefined(this.keysAccessor.getCount());
            this.keysAccessor.write(keysRow, index);
            this.valuesAccessor.write(valuesRow, index);
        }
        this.accessor.endValue(this.getCount(), map.size());
    }

    @Override
    public void finish() {
        super.finish();
        this.keysAccessor.finish();
        this.valuesAccessor.finish();
    }

    @Override
    public void reset() {
        super.reset();
        this.keysAccessor.reset();
        this.valuesAccessor.reset();
    }

    private static LatitudeRow valuesAsRow(List<Object> values, FoundryFieldSchema schema) {
        return GenericLatitudeRow.of(values, Collections.nCopies(values.size(), schema));
    }
}

