/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.org.apache.arrow.vector.VarCharVector;

public final class StringArrowVectorAccessor
extends ArrowVectorAccessor {
    private final VarCharVector accessor;

    public StringArrowVectorAccessor(VarCharVector vector) {
        super(vector);
        this.accessor = vector;
    }

    @Override
    public String getString(int rowId) {
        if (this.accessor.isNull(rowId)) {
            return null;
        }
        byte[] bytes = this.accessor.get(rowId);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public LocalDate getDate(int rowId) {
        String stringValue = this.getString(rowId);
        if (stringValue == null) {
            return null;
        }
        return LocalDate.parse(stringValue, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Override
    protected void setNull() {
        this.accessor.setNull(this.getCount());
    }

    @Override
    protected void setValue(LatitudeRow row, int ordinal) {
        String utf8 = row.getString(ordinal);
        byte[] utf8ByteBuffer = utf8.getBytes(StandardCharsets.UTF_8);
        this.accessor.setSafe(this.getCount(), utf8ByteBuffer, 0, utf8ByteBuffer.length);
    }
}

