/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.contour.ipc.GenericLatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeStruct;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.ArrowLatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.one.util.streamex.EntryStream;
import shadow.palantir.driver.org.apache.arrow.vector.complex.StructVector;

public final class StructArrowVectorAccessor
extends ArrowVectorAccessor {
    private final StructVector accessor;
    private final List<FoundryFieldSchema> schema;
    private final ArrowVectorAccessor[] children;

    public StructArrowVectorAccessor(StructVector vector, ArrowVectorAccessor[] children) {
        super(vector);
        this.accessor = vector;
        this.schema = EntryStream.zip(vector.getChildFieldNames(), ImmutableList.copyOf(children)).mapKeyValue((name, child) -> FoundryFieldSchema.builder().from(child.getType()).name((String)name).build()).collect(Collectors.toList());
        this.children = children;
    }

    @Override
    public LatitudeStruct getStruct(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        ArrowLatitudeRow row = new ArrowLatitudeRow(this.children, rowId);
        Object[] values = new Object[row.numFields()];
        for (int index = 0; index < row.numFields(); ++index) {
            values[index] = row.get(index);
        }
        return LatitudeStruct.of(GenericLatitudeRow.of(Arrays.asList(values), this.schema));
    }

    @Override
    protected void setNull() {
        for (int index = 0; index < this.children.length; ++index) {
            this.children[index].setNull();
            this.children[index].incrementCount();
        }
        this.accessor.setNull(this.getCount());
    }

    @Override
    protected void setValue(LatitudeRow row, int ordinal) {
        LatitudeStruct struct = row.getStruct(ordinal);
        for (int index = 0; index < this.children.length; ++index) {
            this.children[index].write(struct, index);
        }
        this.accessor.setIndexDefined(this.getCount());
    }

    @Override
    public void finish() {
        super.finish();
        for (ArrowVectorAccessor child : this.children) {
            child.finish();
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (ArrowVectorAccessor child : this.children) {
            child.reset();
        }
    }
}

