/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor;

import java.time.Instant;
import shadow.palantir.driver.com.palantir.contour.ipc.LatitudeRow;
import shadow.palantir.driver.com.palantir.contour.ipc.arrow.accessor.ArrowVectorAccessor;
import shadow.palantir.driver.com.palantir.contour.ipc.util.DateTimeUtils;
import shadow.palantir.driver.org.apache.arrow.vector.TimeStampMicroTZVector;

public final class TimestampArrowVectorAccessor
extends ArrowVectorAccessor {
    private final TimeStampMicroTZVector accessor;

    public TimestampArrowVectorAccessor(TimeStampMicroTZVector vector) {
        super(vector);
        this.accessor = vector;
    }

    @Override
    public long getLong(int rowId) {
        return this.accessor.get(rowId);
    }

    @Override
    public Instant getTimestamp(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return DateTimeUtils.microsToInstant(this.accessor.get(rowId));
    }

    @Override
    protected void setNull() {
        this.accessor.setNull(this.getCount());
    }

    @Override
    protected void setValue(LatitudeRow row, int ordinal) {
        this.accessor.setSafe(this.getCount(), DateTimeUtils.instantToMicros(row.getTimestamp(ordinal)));
    }
}

