/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.contour.ipc.util;

import com.palantir.logsafe.Preconditions;
import java.util.Iterator;
import java.util.function.Function;
import shadow.palantir.driver.com.google.common.util.concurrent.Runnables;
import shadow.palantir.driver.com.palantir.contour.ipc.util.CloseableIterator;

public abstract class CloseableIterators {
    private CloseableIterators() {
    }

    public static <T> CloseableIterator<T> of(Iterator<T> iterator) {
        return CloseableIterators.of(iterator, Runnables.doNothing()::run);
    }

    public static <T> CloseableIterator<T> of(final Iterator<T> iterator, final OnCloseRunnable onClose) {
        return new CloseableIterator<T>(){

            @Override
            public void close() throws Exception {
                onClose.run();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static <F, T> CloseableIterator<T> transform(final CloseableIterator<F> fromIterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new CloseableIterator<T>(){

            @Override
            public boolean hasNext() {
                return fromIterator.hasNext();
            }

            @Override
            public T next() {
                return function.apply(fromIterator.next());
            }

            @Override
            public void close() throws Exception {
                fromIterator.close();
            }
        };
    }

    @FunctionalInterface
    public static interface OnCloseRunnable {
        public void run() throws Exception;
    }
}

