/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shadow.palantir.driver.javax.annotation.Nullable;

final class Attachments {
    private final Map<AttachmentKey<?>, Object> attachments = new ConcurrentHashMap(0);

    private Attachments() {
    }

    static Attachments create() {
        return new Attachments();
    }

    @Nullable
    <V> V put(AttachmentKey<V> key, V value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        key.checkIsInstance(value);
        return (V)this.attachments.put(key, value);
    }

    @Nullable
    <V> V getOrDefault(AttachmentKey<V> key, @Nullable V defaultValue) {
        Preconditions.checkNotNull(key, "key");
        return (V)this.attachments.getOrDefault(key, defaultValue);
    }

    static <T> AttachmentKey<T> createAttachmentKey(Class<? super T> valueClazz) {
        Preconditions.checkNotNull(valueClazz, "valueClazz");
        return new AttachmentKey<T>(valueClazz);
    }

    static final class AttachmentKey<V> {
        private final Class<V> valueClazz;

        private AttachmentKey(Class<V> valueClazz) {
            this.valueClazz = valueClazz;
        }

        private void checkIsInstance(V value) {
            if (!this.valueClazz.isInstance(value)) {
                throw new SafeIllegalArgumentException("Unexpected type", SafeArg.of("expected", this.valueClazz), SafeArg.of("actualType", value == null ? null : value.getClass()));
            }
        }
    }
}

