/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue;

import com.palantir.logsafe.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface BinaryRequestBody
extends Closeable {
    public void write(OutputStream var1) throws IOException;

    default public boolean repeatable() {
        return false;
    }

    @Override
    default public void close() throws IOException {
    }

    public static BinaryRequestBody of(final InputStream inputStream) {
        return new BinaryRequestBody(){
            private boolean invoked;

            @Override
            public void write(OutputStream requestBody) throws IOException {
                Preconditions.checkState(!this.invoked, "Write has already been called");
                this.invoked = true;
                inputStream.transferTo(requestBody);
            }

            @Override
            public boolean repeatable() {
                return false;
            }

            @Override
            public void close() throws IOException {
                inputStream.close();
            }
        };
    }
}

