/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeNullPointerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import shadow.palantir.driver.com.google.common.base.Verify;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ListMultimap;
import shadow.palantir.driver.com.google.common.collect.Sets;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.com.palantir.dialogue.UrlBuilder;
import shadow.palantir.driver.javax.annotation.Nullable;

@Immutable
public final class PathTemplate {
    private final ImmutableList<Segment> segments;

    private PathTemplate(Iterable<Segment> segments) {
        this.segments = ImmutableList.copyOf(segments);
        HashSet<String> seenVariables = Sets.newHashSetWithExpectedSize(this.segments.size());
        for (Segment segment : segments) {
            if (segment.variable == null) continue;
            boolean seen = seenVariables.add(segment.variable);
            Preconditions.checkArgument(seen, "Duplicate segment variable names not allowed", SafeArg.of("variable", segment.variable));
        }
    }

    public static PathTemplateBuilder builder() {
        return new PathTemplateBuilder();
    }

    public void fill(Map<String, String> parameters, UrlBuilder url) {
        int numVariableSegments = 0;
        for (Segment segment : this.segments) {
            if (segment.fixed != null) {
                url.pathSegment(segment.fixed);
                continue;
            }
            String variableSegment = parameters.get(segment.variable);
            if (variableSegment == null) {
                throw new SafeNullPointerException("Provided parameter map does not contain segment variable name", SafeArg.of("variable", segment.variable));
            }
            url.pathSegment(variableSegment);
            ++numVariableSegments;
        }
        Verify.verify(numVariableSegments == parameters.size(), "Too many parameters supplied, this is a bug", new Object[0]);
    }

    public void fill(ListMultimap<String, String> parameters, UrlBuilder url) {
        for (Segment segment : this.segments) {
            if (segment.fixed != null) {
                url.pathSegment(segment.fixed);
                continue;
            }
            url.pathSegments(parameters.get((Object)segment.variable));
        }
    }

    @Immutable
    public static final class Segment {
        @Nullable
        private final String fixed;
        @Nullable
        private final String variable;

        private Segment(@Nullable String fixed, @Nullable String variable) {
            this.fixed = fixed;
            this.variable = variable;
        }

        public static Segment fixed(String fixed) {
            return new Segment(fixed, null);
        }

        public static Segment variable(String variable) {
            return new Segment(null, variable);
        }
    }

    public static final class PathTemplateBuilder {
        private final List<Segment> segments = new ArrayList<Segment>();

        public PathTemplateBuilder fixed(String fixed) {
            this.segments.add(Segment.fixed(fixed));
            return this;
        }

        public PathTemplateBuilder variable(String variable) {
            this.segments.add(Segment.variable(variable));
            return this;
        }

        public PathTemplate build() {
            return new PathTemplate(this.segments);
        }
    }
}

