/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public abstract class TypeMarker<T> {
    private final Type type;

    protected TypeMarker() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new SafeIllegalArgumentException("Class is not parameterized", SafeArg.of("class", genericSuperclass));
        }
        this.type = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        if (this.type instanceof TypeVariable) {
            throw new SafeIllegalArgumentException("TypeMarker does not support variable types", SafeArg.of("typeVariable", this.type));
        }
    }

    private TypeMarker(Type type) {
        this.type = Preconditions.checkNotNull(type, "Type is required");
    }

    public final Type getType() {
        return this.type;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TypeMarker) {
            TypeMarker that = (TypeMarker)other;
            return this.type.equals(that.type);
        }
        return false;
    }

    public final int hashCode() {
        return this.type.hashCode();
    }

    public final String toString() {
        return "TypeMarker{type=" + this.type + "}";
    }

    public static TypeMarker<?> of(Type type) {
        return new WrappingTypeMarker(type);
    }

    private static final class WrappingTypeMarker
    extends TypeMarker<Object> {
        private WrappingTypeMarker(Type type) {
            super(type);
        }
    }
}

