/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.blocking;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.SettableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.ThreadFactoryBuilder;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.blocking.BlockingChannel;
import shadow.palantir.driver.com.palantir.dialogue.blocking.CallingThreadExecutor;
import shadow.palantir.driver.com.palantir.dialogue.blocking.DefaultCallingThreadExecutor;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tracing.Tracers;
import shadow.palantir.driver.com.palantir.tritium.metrics.MetricRegistries;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.SharedTaggedMetricRegistries;

public final class BlockingChannelAdapter {
    private static final SafeLogger log = SafeLoggerFactory.get(BlockingChannelAdapter.class);
    private static final Supplier<ExecutorService> blockingExecutor = Suppliers.memoize(() -> Tracers.wrap("dialogue-blocking-channel", Executors.newCachedThreadPool(MetricRegistries.instrument(SharedTaggedMetricRegistries.getSingleton(), new ThreadFactoryBuilder().setNameFormat("dialogue-blocking-channel-%d").setDaemon(true).build(), "dialogue-blocking-channel"))));

    public static Channel of(BlockingChannel blockingChannel) {
        return BlockingChannelAdapter.of(blockingChannel, blockingExecutor.get());
    }

    public static Channel of(BlockingChannel blockingChannel, ExecutorService executor) {
        return new BlockingChannelAdapterChannel(blockingChannel, executor);
    }

    private BlockingChannelAdapter() {
    }

    private static final class BlockingChannelAdapterChannel
    implements Channel {
        private final BlockingChannel delegate;
        private final ExecutorService executor;

        BlockingChannelAdapterChannel(BlockingChannel delegate, ExecutorService executor) {
            this.delegate = delegate;
            this.executor = executor;
        }

        @Override
        public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
            SettableFuture<Response> settableFuture = SettableFuture.create();
            BlockingChannelAdapterTask runnable = new BlockingChannelAdapterTask(this.delegate, endpoint, request, settableFuture);
            try {
                CallingThreadExecutor callingThreadExecutor = request.attachments().getOrDefault(DefaultCallingThreadExecutor.ATTACHMENT_KEY, null);
                if (callingThreadExecutor != null) {
                    callingThreadExecutor.execute(runnable);
                } else {
                    final Future<?> future = this.executor.submit(runnable);
                    DialogueFutures.addDirectCallback(settableFuture, new FutureCallback<Response>(){

                        @Override
                        public void onSuccess(Response _result) {
                        }

                        @Override
                        public void onFailure(Throwable throwable) {
                            if (throwable instanceof CancellationException) {
                                future.cancel(true);
                            }
                        }
                    });
                }
                return settableFuture;
            }
            catch (Error | RuntimeException e) {
                return Futures.immediateFailedFuture(e);
            }
        }

        public String toString() {
            return "BlockingChannelAdapterChannel{delegate=" + this.delegate + ", executor=" + this.executor + "}";
        }

        static final class BlockingChannelAdapterTask
        implements Runnable {
            private final SettableFuture<Response> result;
            private final BlockingChannel delegate;
            private final Endpoint endpoint;
            private final Request request;

            BlockingChannelAdapterTask(BlockingChannel delegate, Endpoint endpoint, Request request, SettableFuture<Response> result) {
                this.result = result;
                this.delegate = delegate;
                this.endpoint = endpoint;
                this.request = request;
            }

            @Override
            public void run() {
                block4: {
                    if (this.result.isDone()) {
                        return;
                    }
                    try {
                        Response response = this.delegate.execute(this.endpoint, this.request);
                        if (!this.result.set(response)) {
                            log.info("Received response, but future has already been completed", SafeArg.of("service", this.endpoint.serviceName()), SafeArg.of("endpoint", this.endpoint.endpointName()), SafeArg.of("futureCancelled", this.result.isCancelled()));
                            response.close();
                        }
                    }
                    catch (Throwable t) {
                        if (this.result.setException(t)) break block4;
                        log.info("Failed to set future exception", SafeArg.of("service", this.endpoint.serviceName()), SafeArg.of("endpoint", this.endpoint.endpointName()), t);
                    }
                }
            }

            public String toString() {
                return "BlockingChannelAdapterTask{delegate=" + this.delegate + ", endpoint=" + this.endpoint + ", request=" + this.request + "}";
            }
        }
    }
}

