/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.math.IntMath;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.BalancedScoreTracker;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.StickyAttachments;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class BalancedNodeSelectionStrategyChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(BalancedNodeSelectionStrategyChannel.class);
    private static final int INFLIGHT_COMPARISON_THRESHOLD = 5;
    private static final int UNHEALTHY_SCORE_MULTIPLIER = 2;
    private final BalancedScoreTracker tracker;
    private final ImmutableList<BalancedChannel> channels;

    BalancedNodeSelectionStrategyChannel(ImmutableList<LimitedChannel> channels, Random random, Ticker ticker, TaggedMetricRegistry taggedMetrics, String channelName) {
        Preconditions.checkState(channels.size() >= 2, "At least two channels required");
        this.tracker = new BalancedScoreTracker(channels.size(), random, ticker, taggedMetrics, channelName);
        this.channels = IntStream.range(0, channels.size()).mapToObj(index -> new BalancedChannel((LimitedChannel)channels.get(index), (BalancedScoreTracker.ChannelScoreInfo)this.tracker.channelStats().get(index))).collect(ImmutableList.toImmutableList());
        log.debug("Initialized", SafeArg.of("count", channels.size()), UnsafeArg.of("channels", channels));
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        BalancedScoreTracker.ScoreSnapshot[] snapshotsByScore = this.tracker.getSnapshotsInOrderOfIncreasingScore();
        int giveUpThreshold = Integer.MAX_VALUE;
        for (BalancedScoreTracker.ScoreSnapshot snapshot : snapshotsByScore) {
            BalancedChannel channel;
            Optional<ListenableFuture<Response>> maybe;
            if (snapshot.getScore() > giveUpThreshold) {
                if (log.isDebugEnabled()) {
                    log.debug("Giving up and queueing because channel score ({}) for channel {} is not worth sending a request to ({})", SafeArg.of("score", snapshot.getScore()), SafeArg.of("hostIndex", snapshot.getDelegate().channelIndex()), SafeArg.of("giveUpScore", giveUpThreshold));
                }
                return Optional.empty();
            }
            if (snapshot.getInflight() > 5) {
                int newThreshold = IntMath.saturatedMultiply(snapshot.getScore(), 2);
                if (log.isDebugEnabled()) {
                    log.debug("When considering channel {}, giveUpThreshold {} -> {}", SafeArg.of("hostIndex", snapshot.getDelegate().channelIndex()), SafeArg.of("old", giveUpThreshold), SafeArg.of("new", newThreshold));
                }
                giveUpThreshold = newThreshold;
            }
            if (!(maybe = StickyAttachments.maybeAddStickyToken(channel = (BalancedChannel)this.channels.get(snapshot.getDelegate().channelIndex()), endpoint, request, limitEnforcement)).isPresent()) continue;
            return maybe;
        }
        return Optional.empty();
    }

    @VisibleForTesting
    IntStream getScoresForTesting() {
        return this.tracker.getScoresForTesting();
    }

    public String toString() {
        return "BalancedNodeSelectionStrategyChannel{channels=" + this.channels + ", tracker=" + this.tracker + "}";
    }

    private static final class BalancedChannel
    implements LimitedChannel {
        private final LimitedChannel delegate;
        private final BalancedScoreTracker.ChannelScoreInfo channelInfo;

        BalancedChannel(LimitedChannel delegate, BalancedScoreTracker.ChannelScoreInfo channelInfo) {
            this.delegate = delegate;
            this.channelInfo = channelInfo;
        }

        @Override
        public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
            this.channelInfo.startRequest();
            Optional<ListenableFuture<Response>> maybe = this.delegate.maybeExecute(endpoint, request, limitEnforcement);
            if (maybe.isPresent()) {
                this.channelInfo.observability().markRequestMade();
                DialogueFutures.addDirectCallback(maybe.get(), this.channelInfo);
                return maybe;
            }
            this.channelInfo.undoStartRequest();
            return Optional.empty();
        }

        public String toString() {
            return "BalancedChannel{delegate=" + this.delegate + ", channelInfo=" + this.channelInfo + "}";
        }
    }
}

