/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.CharMatcher;
import shadow.palantir.driver.com.google.common.base.Joiner;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.common.base.Supplier;
import shadow.palantir.driver.com.google.common.collect.Collections2;
import shadow.palantir.driver.com.google.common.collect.ListMultimap;
import shadow.palantir.driver.com.google.common.collect.Multimap;
import shadow.palantir.driver.com.google.common.collect.Multimaps;
import shadow.palantir.driver.com.google.common.net.InetAddresses;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.UrlBuilder;

public final class BaseUrl {
    private final DefaultUrlBuilder builder;

    public static BaseUrl of(URL baseUrl) {
        return new BaseUrl(DefaultUrlBuilder.from(baseUrl));
    }

    private BaseUrl(DefaultUrlBuilder builder) {
        this.builder = builder;
    }

    public URL render(Endpoint endpoint, Request request) {
        DefaultUrlBuilder url = this.builder.newBuilder();
        endpoint.renderPath(request.pathParameters(), (UrlBuilder)url);
        request.queryParams().forEach(url::queryParam);
        return url.build();
    }

    public String toString() {
        return "BaseUrl{builder=" + this.builder + "}";
    }

    @VisibleForTesting
    static class UrlEncoder {
        private static final CharMatcher DIGIT = CharMatcher.inRange('0', '9');
        private static final CharMatcher ALPHA = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z'));
        private static final CharMatcher UNRESERVED = DIGIT.or(ALPHA).or(CharMatcher.anyOf("-._~"));
        private static final CharMatcher SUB_DELIMS = CharMatcher.anyOf("!$&'()*+,;=");
        private static final CharMatcher IS_HOST = UNRESERVED.or(SUB_DELIMS);
        private static final CharMatcher IS_P_CHAR = UNRESERVED.or(CharMatcher.is(':'));
        private static final CharMatcher IS_PATH = IS_P_CHAR.or(SUB_DELIMS).or(CharMatcher.is('/'));
        private static final CharMatcher IS_QUERY_CHAR = IS_P_CHAR.or(CharMatcher.anyOf("/?"));

        UrlEncoder() {
        }

        static boolean isHost(String maybeHost) {
            return IS_HOST.matchesAllOf(maybeHost) || UrlEncoder.isIpv6Host(maybeHost);
        }

        static boolean isIpv6Host(String maybeHost) {
            int length = maybeHost.length();
            return length > 2 && maybeHost.codePointAt(0) == 91 && maybeHost.codePointAt(length - 1) == 93 && InetAddresses.isInetAddress(maybeHost.substring(1, length - 1));
        }

        static boolean isPath(String path) {
            return IS_PATH.matchesAllOf(path);
        }

        static String encodePathSegment(String pathComponent) {
            return UrlEncoder.encode(pathComponent, IS_P_CHAR);
        }

        static String encodeQueryNameOrValue(String nameOrValue) {
            return UrlEncoder.encode(nameOrValue, IS_QUERY_CHAR);
        }

        @VisibleForTesting
        static String encode(String source, CharMatcher charactersToKeep) {
            byte[] bytes = source.getBytes(StandardCharsets.UTF_8);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length());
            boolean wasChanged = false;
            for (byte b : bytes) {
                if (charactersToKeep.matches(UrlEncoder.toChar(b))) {
                    bos.write(b);
                    continue;
                }
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
                wasChanged = true;
            }
            return wasChanged ? new String(bos.toByteArray(), StandardCharsets.UTF_8) : source;
        }

        private static char toChar(byte theByte) {
            if (theByte < 0) {
                return (char)(256 + theByte);
            }
            return (char)theByte;
        }
    }

    @VisibleForTesting
    static final class DefaultUrlBuilder
    implements UrlBuilder {
        private static final Joiner PATH_JOINER = Joiner.on('/');
        private static final Joiner.MapJoiner QUERY_JOINER = Joiner.on('&').withKeyValueSeparator('=');
        private static final Supplier<List<String>> MAP_VALUE_FACTORY = () -> new ArrayList(1);
        private final String protocol;
        private final String host;
        private final int port;
        private final List<String> pathSegments;
        private final Multimap<String, String> queryNamesAndValues;

        static DefaultUrlBuilder from(URL baseUrl) {
            if (!baseUrl.getProtocol().equals("http") && !baseUrl.getProtocol().equals("https")) {
                throw new SafeIllegalArgumentException("unsupported protocol", SafeArg.of("protocol", baseUrl.getProtocol()));
            }
            if (Strings.emptyToNull(baseUrl.getQuery()) != null) {
                throw new SafeIllegalArgumentException("baseUrl query must be empty", UnsafeArg.of("query", baseUrl.getQuery()));
            }
            if (Strings.emptyToNull(baseUrl.getRef()) != null) {
                throw new SafeIllegalArgumentException("baseUrl ref must be empty", UnsafeArg.of("ref", baseUrl.getRef()));
            }
            if (Strings.emptyToNull(baseUrl.getUserInfo()) != null) {
                throw new SafeIllegalArgumentException("baseUrl user info must be empty", new Arg[0]);
            }
            return new DefaultUrlBuilder(baseUrl);
        }

        private DefaultUrlBuilder(URL url) {
            this.protocol = url.getProtocol();
            this.host = url.getHost();
            this.port = url.getPort();
            this.pathSegments = new ArrayList<String>();
            this.queryNamesAndValues = DefaultUrlBuilder.createQueryParameterMap();
            Preconditions.checkArgument(this.port >= -1 && this.port <= 65535, "port must be in range [0, 65535] or default [-1]");
            String strippedBasePath = DefaultUrlBuilder.stripSlashes(url.getPath());
            if (!strippedBasePath.isEmpty()) {
                this.encodedPathSegments(strippedBasePath);
            }
        }

        DefaultUrlBuilder newBuilder() {
            return new DefaultUrlBuilder(this);
        }

        private DefaultUrlBuilder(DefaultUrlBuilder builder) {
            this.protocol = builder.protocol;
            this.host = builder.host;
            this.port = builder.port;
            this.pathSegments = new ArrayList<String>(builder.pathSegments);
            this.queryNamesAndValues = DefaultUrlBuilder.createQueryParameterMap();
            this.queryNamesAndValues.putAll(builder.queryNamesAndValues);
        }

        private static ListMultimap<String, String> createQueryParameterMap() {
            return Multimaps.newListMultimap(new LinkedHashMap(), MAP_VALUE_FACTORY);
        }

        DefaultUrlBuilder encodedPathSegments(String segments) {
            if (!UrlEncoder.isPath(segments)) {
                throw new SafeIllegalArgumentException("invalid characters in encoded path segments", UnsafeArg.of("segments", segments));
            }
            this.pathSegments.add(segments);
            return this;
        }

        @Override
        public DefaultUrlBuilder pathSegment(String thePath) {
            this.pathSegments.add(UrlEncoder.encodePathSegment(thePath));
            return this;
        }

        @Override
        public DefaultUrlBuilder pathSegments(Collection<String> paths) {
            this.pathSegments.addAll(Collections2.transform(paths, UrlEncoder::encodePathSegment));
            return this;
        }

        @Override
        public DefaultUrlBuilder queryParam(String name, String value) {
            this.queryNamesAndValues.put(UrlEncoder.encodeQueryNameOrValue(name), UrlEncoder.encodeQueryNameOrValue(value));
            return this;
        }

        URL build() {
            try {
                Preconditions.checkNotNull(this.protocol, "protocol must be set");
                Preconditions.checkNotNull(this.host, "host must be set");
                Preconditions.checkArgument(this.port >= -1, "port must be set");
                StringBuilder file = new StringBuilder();
                DefaultUrlBuilder.encodePath(this.pathSegments, file);
                DefaultUrlBuilder.encodeQuery(this.queryNamesAndValues, file);
                return new URL(this.protocol, this.host, this.port, file.toString());
            }
            catch (MalformedURLException e) {
                throw new SafeIllegalArgumentException("Malformed URL", (Throwable)e, new Arg[0]);
            }
        }

        private static void encodePath(List<String> segments, StringBuilder result) {
            if (!segments.isEmpty()) {
                result.append('/');
            }
            PATH_JOINER.appendTo(result, (Iterable<?>)segments);
        }

        private static void encodeQuery(Multimap<String, String> queryParams, StringBuilder result) {
            if (!queryParams.isEmpty()) {
                result.append('?');
            }
            QUERY_JOINER.appendTo(result, (Iterable<? extends Map.Entry<?, ?>>)queryParams.entries());
        }

        private static String stripSlashes(String path) {
            if (path.isEmpty()) {
                return path;
            }
            if (path.equals("/")) {
                return "";
            }
            int stripStart = path.startsWith("/") ? 1 : 0;
            int stripEnd = path.endsWith("/") ? 1 : 0;
            return path.substring(stripStart, path.length() - stripEnd);
        }

        public String toString() {
            return "UrlBuilderImpl{protocol='" + this.protocol + "', host='" + this.host + "', port=" + this.port + ", pathSegments=" + this.pathSegments + ", queryNamesAndValues=" + this.queryNamesAndValues + "}";
        }
    }
}

