/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;

final class ChannelToEndpointChannel
implements Channel {
    private final Function<Endpoint, Channel> adapter;
    private final Map<Object, Channel> cache;

    ChannelToEndpointChannel(Function<Endpoint, Channel> adapter) {
        this.adapter = adapter;
        this.cache = new ConcurrentHashMap<Object, Channel>();
    }

    @Override
    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        return this.channelFor(endpoint).execute(endpoint, request);
    }

    private Channel channelFor(Endpoint endpoint) {
        return this.cache.computeIfAbsent(ChannelToEndpointChannel.key(endpoint), _key -> this.adapter.apply(endpoint));
    }

    static boolean isConstant(Endpoint endpoint) {
        return endpoint instanceof Enum;
    }

    private static Object key(Endpoint endpoint) {
        return ChannelToEndpointChannel.isConstant(endpoint) ? endpoint : ChannelToEndpointChannel.stringKey(endpoint);
    }

    private static String stringKey(Endpoint endpoint) {
        return endpoint.serviceName() + "." + endpoint.endpointName();
    }
}

