/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class ClientMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "4.0.0";
    private final TaggedMetricRegistry registry;

    private ClientMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static ClientMetrics of(TaggedMetricRegistry registry) {
        return new ClientMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    ResponseBuilderChannelNameStage response() {
        return new ResponseBuilder();
    }

    @CheckReturnValue
    Meter deprecations(@Safe String serviceName) {
        return this.registry.meter(ClientMetrics.deprecationsMetricName(serviceName));
    }

    static MetricName deprecationsMetricName(@Safe String serviceName) {
        return MetricName.builder().safeName("client.deprecations").putSafeTags("service-name", serviceName).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    public String toString() {
        return "ClientMetrics{registry=" + this.registry + "}";
    }

    private final class ResponseBuilder
    implements ResponseBuilderChannelNameStage,
    ResponseBuilderServiceNameStage,
    ResponseBuilderEndpointStage,
    ResponseBuilderStatusStage,
    ResponseBuildStage {
        private String channelName;
        private String serviceName;
        private String endpoint;
        private String status;

        private ResponseBuilder() {
        }

        @Override
        public ResponseBuilder channelName(@Safe String channelName) {
            Preconditions.checkState(this.channelName == null, "channel-name is already set");
            this.channelName = Preconditions.checkNotNull(channelName, "channel-name is required");
            return this;
        }

        @Override
        public ResponseBuilder serviceName(@Safe String serviceName) {
            Preconditions.checkState(this.serviceName == null, "service-name is already set");
            this.serviceName = Preconditions.checkNotNull(serviceName, "service-name is required");
            return this;
        }

        @Override
        public ResponseBuilder endpoint(@Safe String endpoint) {
            Preconditions.checkState(this.endpoint == null, "endpoint is already set");
            this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint is required");
            return this;
        }

        @Override
        public ResponseBuilder status(@Safe String status) {
            Preconditions.checkState(this.status == null, "status is already set");
            this.status = Preconditions.checkNotNull(status, "status is required");
            return this;
        }

        @Override
        public Timer build() {
            return ClientMetrics.this.registry.timer(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("client.response").putSafeTags("channel-name", this.channelName).putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).putSafeTags("status", this.status).putSafeTags("libraryName", ClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", ClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ResponseBuilderStatusStage {
        @CheckReturnValue
        public ResponseBuildStage status(@Safe String var1);
    }

    static interface ResponseBuilderEndpointStage {
        @CheckReturnValue
        public ResponseBuilderStatusStage endpoint(@Safe String var1);
    }

    static interface ResponseBuilderServiceNameStage {
        @CheckReturnValue
        public ResponseBuilderEndpointStage serviceName(@Safe String var1);
    }

    static interface ResponseBuilderChannelNameStage {
        @CheckReturnValue
        public ResponseBuilderServiceNameStage channelName(@Safe String var1);
    }

    static interface ResponseBuildStage {
        @CheckReturnValue
        public Timer build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

