/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;
import java.util.stream.LongStream;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.CautiousIncreaseAggressiveDecreaseConcurrencyLimiter;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueConcurrencylimiterMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueInternalWeakReducingGauge;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.NeverThrowChannel;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class ConcurrencyLimitedChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(ConcurrencyLimitedChannel.class);
    private final NeverThrowChannel delegate;
    private final CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter;
    private final String channelNameForLogging;

    static LimitedChannel createForHost(Config cf, Channel channel, int uriIndex) {
        TaggedMetricRegistry metrics = cf.clientConf().taggedMetricRegistry();
        CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter = ConcurrencyLimitedChannel.createLimiter(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Behavior.HOST_LEVEL);
        HostConcurrencyLimitedChannelInstrumentation instrumentation = new HostConcurrencyLimitedChannelInstrumentation(cf.channelName(), uriIndex, limiter, metrics);
        return new ConcurrencyLimitedChannel(channel, limiter, instrumentation);
    }

    static LimitedChannel createForEndpoint(Channel channel, String channelName, int uriIndex, Endpoint endpoint) {
        return new ConcurrencyLimitedChannel(channel, ConcurrencyLimitedChannel.createLimiter(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Behavior.ENDPOINT_LEVEL), new EndpointConcurrencyLimitedChannelInstrumentation(channelName, uriIndex, endpoint));
    }

    ConcurrencyLimitedChannel(Channel delegate, CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter, ConcurrencyLimitedChannelInstrumentation instrumentation) {
        this.delegate = new NeverThrowChannel(delegate);
        this.limiter = limiter;
        this.channelNameForLogging = instrumentation.channelNameForLogging();
    }

    static CautiousIncreaseAggressiveDecreaseConcurrencyLimiter createLimiter(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Behavior behavior) {
        return new CautiousIncreaseAggressiveDecreaseConcurrencyLimiter(behavior);
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        Optional<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit> maybePermit = this.limiter.acquire(limitEnforcement);
        if (maybePermit.isPresent()) {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit permit = maybePermit.get();
            this.logPermitAcquired();
            ListenableFuture<Response> result = this.delegate.execute(endpoint, request);
            DialogueFutures.addDirectCallback(result, permit);
            return Optional.of(result);
        }
        this.logPermitRefused();
        return Optional.empty();
    }

    private void logPermitAcquired() {
        if (log.isDebugEnabled()) {
            log.debug("Sending {}/{} on {}", SafeArg.of("inflight", this.limiter.getInflight()), SafeArg.of("max", this.limiter.getLimit()), SafeArg.of("channel", this.channelNameForLogging));
        }
    }

    private void logPermitRefused() {
        if (log.isDebugEnabled()) {
            log.debug("Limited {} on {}", SafeArg.of("max", this.limiter.getLimit()), SafeArg.of("channel", this.channelNameForLogging));
        }
    }

    public String toString() {
        return "ConcurrencyLimitedChannel{delegate=" + this.delegate + ", name=" + this.channelNameForLogging + "}";
    }

    static final class EndpointConcurrencyLimitedChannelInstrumentation
    implements ConcurrencyLimitedChannelInstrumentation {
        private final String channelNameForLogging;

        EndpointConcurrencyLimitedChannelInstrumentation(String channelName, int uriIndex, Endpoint endpoint) {
            this.channelNameForLogging = channelName + "{uriIndex=" + uriIndex + ", endpoint=" + endpoint.serviceName() + "." + endpoint.endpointName() + "}";
        }

        @Override
        public String channelNameForLogging() {
            return this.channelNameForLogging;
        }
    }

    static final class HostConcurrencyLimitedChannelInstrumentation
    implements ConcurrencyLimitedChannelInstrumentation {
        private final String channelNameForLogging;

        HostConcurrencyLimitedChannelInstrumentation(String channelName, int uriIndex, CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter, TaggedMetricRegistry taggedMetrics) {
            if (uriIndex == -1) {
                throw new SafeIllegalArgumentException("uriIndex must be specified", SafeArg.of("channel-name", channelName));
            }
            this.channelNameForLogging = channelName + "{uriIndex=" + uriIndex + "}";
            DialogueConcurrencylimiterMetrics metrics = DialogueConcurrencylimiterMetrics.of(taggedMetrics);
            DialogueInternalWeakReducingGauge.getOrCreateDouble(taggedMetrics, metrics.max().channelName(channelName).hostIndex(Integer.toString(uriIndex)).buildMetricName(), CautiousIncreaseAggressiveDecreaseConcurrencyLimiter::getLimit, doubleStream -> doubleStream.min().orElse(0.0), limiter);
            DialogueInternalWeakReducingGauge.getOrCreate(taggedMetrics, metrics.inFlight().channelName(channelName).hostIndex(Integer.toString(uriIndex)).buildMetricName(), CautiousIncreaseAggressiveDecreaseConcurrencyLimiter::getInflight, LongStream::sum, limiter);
        }

        @Override
        public String channelNameForLogging() {
            return this.channelNameForLogging;
        }
    }

    static interface ConcurrencyLimitedChannelInstrumentation {
        public String channelNameForLogging();
    }
}

