/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfiguration;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.core.MeshMode;
import shadow.palantir.driver.com.palantir.dialogue.core.RetryingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.TargetUri;
import shadow.palantir.driver.com.palantir.random.SafeThreadLocalRandom;
import shadow.palantir.driver.com.palantir.refreshable.Refreshable;
import shadow.palantir.driver.org.immutables.value.Value;

@DoNotLog
@Value.Immutable
interface Config {
    public String channelName();

    public DialogueChannelFactory channelFactory();

    public ClientConfiguration rawConfig();

    @Value.Derived
    default public ClientConfiguration clientConf() {
        return ClientConfiguration.builder().from(this.rawConfig()).uris(this.rawConfig().uris().stream().map(MeshMode::stripMeshPrefix).collect(ImmutableList.toImmutableList())).build();
    }

    @Value.Default
    default public Refreshable<List<TargetUri>> uris() {
        return Refreshable.only(this.rawConfig().uris().stream().map(TargetUri::of).collect(Collectors.toUnmodifiableList()));
    }

    @Value.Derived
    default public MeshMode mesh() {
        return MeshMode.fromUris(this.rawConfig().uris(), SafeArg.of("channelName", this.channelName()));
    }

    @Value.Derived
    default public boolean isConcurrencyLimitingEnabled() {
        return this.rawConfig().clientQoS() == ClientConfiguration.ClientQoS.ENABLED && this.mesh() != MeshMode.USE_EXTERNAL_MESH;
    }

    @Value.Default
    default public Random random() {
        return SafeThreadLocalRandom.get();
    }

    @Value.Default
    default public ScheduledExecutorService scheduler() {
        return RetryingChannel.sharedScheduler.get();
    }

    @Value.Default
    default public Ticker ticker() {
        return Ticker.systemTicker();
    }

    @Value.Default
    default public int maxQueueSize() {
        return 100000;
    }

    public OptionalInt overrideSingleHostIndex();

    @Value.Check
    default public void check() {
        Preconditions.checkArgument(this.maxQueueSize() > 0, "maxQueueSize must be positive");
        Preconditions.checkArgument(this.rawConfig().userAgent().isPresent(), "userAgent must be specified");
        Preconditions.checkArgument(this.rawConfig().retryOnSocketException() == ClientConfiguration.RetryOnSocketException.ENABLED, "Retries on socket exceptions cannot be disabled without disabling retries entirely.");
        if (this.uris().get().size() > 1 && this.overrideSingleHostIndex().isPresent()) {
            throw new SafeIllegalArgumentException("overrideHostIndex is only permitted when there is a single uri", SafeArg.of("numUris", this.rawConfig().uris().size()));
        }
    }
}

