/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.zip.GZIPOutputStream;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.RequestBody;
import shadow.palantir.driver.com.palantir.dialogue.Response;

final class ContentEncodingChannel
implements EndpointChannel {
    private static final String ENABLEMENT_TAG = "compress-request";
    private static final String GZIP = "gzip";
    private static final int BUFFER_SIZE = 8192;
    private final EndpointChannel delegate;

    static EndpointChannel of(EndpointChannel delegate, Endpoint endpoint) {
        if (endpoint.tags().contains(ENABLEMENT_TAG)) {
            return new ContentEncodingChannel(delegate);
        }
        return delegate;
    }

    ContentEncodingChannel(EndpointChannel delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "Channel is required");
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        Request augmentedRequest = ContentEncodingChannel.wrap(request);
        return this.delegate.execute(augmentedRequest);
    }

    static Request wrap(Request request) {
        Optional<RequestBody> body = request.body();
        if (body.isEmpty() || request.headerParams().containsKey("Content-Encoding") || request.headerParams().containsKey("Content-Length")) {
            return request;
        }
        return Request.builder().from(request).putHeaderParams("Content-Encoding", GZIP).body(new ContentEncodingRequestBody(body.get())).build();
    }

    public String toString() {
        return "ContentEncodingChannel{" + this.delegate + "}";
    }

    private static final class BestSpeedGzipOutputStream
    extends GZIPOutputStream {
        BestSpeedGzipOutputStream(OutputStream out) throws IOException {
            super(out, 8192);
            this.def.setLevel(1);
        }

        public String toString() {
            return "BestSpeedGzipOutputStream{" + this.out + "}";
        }
    }

    private static final class ContentEncodingRequestBody
    implements RequestBody {
        private final RequestBody delegate;

        ContentEncodingRequestBody(RequestBody delegate) {
            this.delegate = delegate;
        }

        @Override
        public void writeTo(OutputStream output) throws IOException {
            try (BestSpeedGzipOutputStream gzipOutput = new BestSpeedGzipOutputStream(output);
                 BufferedOutputStream bufferedOutput = new BufferedOutputStream(gzipOutput, 8192);){
                this.delegate.writeTo(bufferedOutput);
            }
        }

        @Override
        public String contentType() {
            return this.delegate.contentType();
        }

        @Override
        public boolean repeatable() {
            return this.delegate.repeatable();
        }

        @Override
        public OptionalLong contentLength() {
            return OptionalLong.empty();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        public String toString() {
            return "ContentEncodingRequestBody{" + this.delegate + "}";
        }
    }
}

